/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.GroupID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class ResourceManagerThrottleMessage
extends DSOMessageBase {
    private static final byte EXCEPTION_ID = 1;
    private static final byte THROTTLE_ID = 2;
    private static final byte GROUP_ID = 3;
    private boolean exception;
    private float throttle;
    private GroupID groupID;

    public ResourceManagerThrottleMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ResourceManagerThrottleMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public GroupID getGroupID() {
        return this.groupID;
    }

    public boolean getThrowException() {
        return this.exception;
    }

    public float getThrottle() {
        return this.throttle;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.exception);
        this.putNVPair((byte)2, this.throttle);
        this.putNVPair((byte)3, this.groupID.toInt());
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.exception = this.getBooleanValue();
                return true;
            }
            case 2: {
                this.throttle = this.getFloatValue();
                return true;
            }
            case 3: {
                this.groupID = new GroupID(this.getIntValue());
                return true;
            }
        }
        return false;
    }

    public void initialize(GroupID groupId, boolean exceptionParam, float throttleParam) {
        this.exception = exceptionParam;
        this.throttle = throttleParam;
        this.groupID = groupId;
    }
}

