/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.dna.impl.ObjectDNAImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.RequestManagedObjectResponseMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class RequestManagedObjectResponseMessageImpl
extends DSOMessageBase
implements RequestManagedObjectResponseMessage {
    private static final byte SERIALIZER_ID = 1;
    private static final byte TOTAL_ID = 2;
    private static final byte BATCH_ID = 3;
    private static final byte DNA_COUNT = 4;
    private static final byte DNA_DATA = 5;
    private Collection objects;
    private ObjectStringSerializer serializer;
    private int total;
    private long batchID;
    private TCByteBuffer[] dnaData;
    private int dnaCount;

    public RequestManagedObjectResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public RequestManagedObjectResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public Collection getObjects() {
        return Collections.unmodifiableCollection(this.objects);
    }

    @Override
    public void initialize(TCByteBuffer[] dnas, int count, ObjectStringSerializer aSerializer, long bid, int tot) {
        this.dnaCount = count;
        this.dnaData = dnas;
        this.serializer = aSerializer;
        this.batchID = bid;
        this.total = tot;
    }

    @Override
    public ObjectStringSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public long getBatchID() {
        return this.batchID;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.serializer);
        this.putNVPair((byte)3, this.batchID);
        this.putNVPair((byte)2, this.total);
        this.putNVPair((byte)4, this.dnaCount);
        this.putNVPair((byte)5, this.dnaData);
        this.dnaData = null;
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 5: {
                int n = this.dnaCount;
                for (int i = 0; i < n; ++i) {
                    this.objects.add(this.getObject(new ObjectDNAImpl(this.serializer, false)));
                }
                return true;
            }
            case 4: {
                this.dnaCount = this.getIntValue();
                this.objects = new ArrayList(this.dnaCount);
                return true;
            }
            case 3: {
                this.batchID = this.getLongValue();
                return true;
            }
            case 2: {
                this.total = this.getIntValue();
                return true;
            }
            case 1: {
                this.serializer = (ObjectStringSerializer)this.getObject(new ObjectStringSerializerImpl());
                return true;
            }
        }
        return false;
    }

    @Override
    public void doRecycleOnRead() {
    }
}

