/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.async.api.EventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectRequestID;
import com.tc.object.ObjectRequestServerContext;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.RequestManagedObjectMessage;
import com.tc.object.session.SessionID;
import com.tc.util.BasicObjectIDSet;
import com.tc.util.ObjectIDSet;
import java.io.IOException;

public class RequestManagedObjectMessageImpl
extends DSOMessageBase
implements EventContext,
RequestManagedObjectMessage {
    private static final byte MANAGED_OBJECT_ID = 1;
    private static final byte MANAGED_OBJECTS_REMOVED_ID = 2;
    private static final byte REQUEST_ID = 4;
    private static final byte REQUEST_DEPTH_ID = 5;
    private static final byte REQUESTING_THREAD_NAME = 6;
    private ObjectIDSet objectIDs;
    private ObjectIDSet removed;
    private ObjectRequestID requestID;
    private int requestDepth;
    private String threadName;

    public RequestManagedObjectMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public RequestManagedObjectMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.objectIDs);
        this.putNVPair((byte)2, this.removed);
        this.putNVPair((byte)4, this.requestID.toLong());
        this.putNVPair((byte)5, this.requestDepth);
        this.putNVPair((byte)6, this.threadName);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.objectIDs = (ObjectIDSet)this.getObject(new BasicObjectIDSet());
                return true;
            }
            case 2: {
                this.removed = (ObjectIDSet)this.getObject(new BasicObjectIDSet());
                return true;
            }
            case 4: {
                this.requestID = new ObjectRequestID(this.getLongValue());
                return true;
            }
            case 5: {
                this.requestDepth = this.getIntValue();
                return true;
            }
            case 6: {
                this.threadName = this.getStringValue();
                return true;
            }
        }
        return false;
    }

    @Override
    public ObjectRequestID getRequestID() {
        return this.requestID;
    }

    public ObjectIDSet getRequestedObjectIDs() {
        return this.objectIDs;
    }

    @Override
    public ObjectIDSet getRemoved() {
        return this.removed;
    }

    @Override
    public void initialize(ObjectRequestID rid, ObjectIDSet requestedObjectIDs, int depth, ObjectIDSet removeObjects) {
        this.requestID = rid;
        this.objectIDs = requestedObjectIDs;
        this.removed = removeObjects;
        this.requestDepth = depth;
        this.threadName = Thread.currentThread().getName();
    }

    @Override
    public int getRequestDepth() {
        return this.requestDepth;
    }

    @Override
    public String getRequestingThreadName() {
        return this.threadName;
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getSourceNodeID();
    }

    @Override
    public Object getKey() {
        return this.getSourceNodeID();
    }

    @Override
    public ObjectRequestServerContext.LOOKUP_STATE getLookupState() {
        return ObjectRequestServerContext.LOOKUP_STATE.CLIENT;
    }
}

