/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.ObjectsNotFoundMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ObjectsNotFoundMessageImpl
extends DSOMessageBase
implements ObjectsNotFoundMessage {
    private static final byte BATCH_ID = 0;
    private static final byte MISSING_OID = 1;
    private Set missingOids;
    private long batchID;

    public ObjectsNotFoundMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ObjectsNotFoundMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initialize(Set missingObjectIDs, long batchId) {
        this.missingOids = missingObjectIDs;
        this.batchID = batchId;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.batchID);
        for (ObjectID oid : this.missingOids) {
            this.putNVPair((byte)1, oid.toLong());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.batchID = this.getLongValue();
                return true;
            }
            case 1: {
                if (this.missingOids == null) {
                    this.missingOids = new HashSet();
                }
                this.missingOids.add(new ObjectID(this.getLongValue()));
                return true;
            }
        }
        return false;
    }

    @Override
    public long getBatchID() {
        return this.batchID;
    }

    @Override
    public Set getMissingObjectIDs() {
        return this.missingOids;
    }
}

