/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapRequestID;
import com.tc.object.ServerMapRequestType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.ObjectNotFoundServerMapResponseMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class ObjectNotFoundServerMapResponseMessageImpl
extends DSOMessageBase
implements ObjectNotFoundServerMapResponseMessage {
    private static final byte MAP_OBJECT_ID = 0;
    private static final byte REQUEST_ID = 1;
    private static final byte REQUEST_TYPE = 2;
    private ObjectID mapID;
    private ServerMapRequestID requestID;
    private ServerMapRequestType requestType;

    public ObjectNotFoundServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public ObjectNotFoundServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    @Override
    public void initialize(ObjectID aMapID, ServerMapRequestID aRequestID, ServerMapRequestType type) {
        this.mapID = aMapID;
        this.requestID = aRequestID;
        this.requestType = type;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.mapID.toLong());
        this.putNVPair((byte)1, this.requestID.toLong());
        this.putNVPair((byte)2, this.requestType.ordinal());
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.mapID = new ObjectID(this.getLongValue());
                return true;
            }
            case 1: {
                this.requestID = new ServerMapRequestID(this.getLongValue());
                return true;
            }
            case 2: {
                this.requestType = ServerMapRequestType.fromOrdinal(this.getIntValue());
                return true;
            }
        }
        return false;
    }

    public ClientID getClientID() {
        return (ClientID)this.getSourceNodeID();
    }

    @Override
    public ObjectID getMapID() {
        return this.mapID;
    }

    @Override
    public ServerMapRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public ServerMapRequestType getRequestType() {
        return this.requestType;
    }
}

