/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodesWithObjectsResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodesWithObjectsResponseMessageImpl
extends DSOMessageBase
implements NodesWithObjectsResponseMessage {
    private static final byte THREAD_ID = 1;
    private static final byte MANAGED_OBJECT_ID = 2;
    private static final byte NODE_ID = 3;
    private ThreadID threadID;
    private Map<ObjectID, Set<NodeID>> nodesWithObjects;
    private Set<NodeID> lastHydratedNodeIDSet;

    public NodesWithObjectsResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public NodesWithObjectsResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initialize(ThreadID tID, Map<ObjectID, Set<NodeID>> response) {
        this.threadID = tID;
        this.nodesWithObjects = response;
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        Assert.assertNotNull(this.nodesWithObjects);
        this.putNVPair((byte)1, this.threadID.toLong());
        for (Map.Entry<ObjectID, Set<NodeID>> entry : this.nodesWithObjects.entrySet()) {
            this.putNVPair((byte)2, entry.getKey().toLong());
            for (NodeID nodeID : entry.getValue()) {
                this.putNVPair((byte)3, nodeID);
            }
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        if (null == this.nodesWithObjects) {
            this.nodesWithObjects = new HashMap<ObjectID, Set<NodeID>>();
        }
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                ObjectID objectID = new ObjectID(this.getLongValue());
                this.lastHydratedNodeIDSet = new HashSet<NodeID>();
                this.nodesWithObjects.put(objectID, this.lastHydratedNodeIDSet);
                return true;
            }
            case 3: {
                Assert.assertNotNull(this.lastHydratedNodeIDSet);
                NodeID nodeID = this.getNodeIDValue();
                this.lastHydratedNodeIDSet.add(nodeID);
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public Map<ObjectID, Set<NodeID>> getNodesWithObjects() {
        return this.nodesWithObjects;
    }
}

