/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodesWithObjectsMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class NodesWithObjectsMessageImpl
extends DSOMessageBase
implements NodesWithObjectsMessage {
    private static final byte THREAD_ID = 1;
    private static final byte MANAGED_OBJECT_ID = 2;
    private final Set<ObjectID> objectIDs = new HashSet<ObjectID>();
    private ThreadID threadID;

    public NodesWithObjectsMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
    }

    public NodesWithObjectsMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public Set<ObjectID> getObjectIDs() {
        return this.objectIDs;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public void setThreadID(ThreadID threadID) {
        this.threadID = threadID;
    }

    @Override
    public void addObjectID(ObjectID objectID) {
        this.objectIDs.add(objectID);
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        this.putNVPair((byte)1, this.threadID.toLong());
        for (ObjectID objectID : this.objectIDs) {
            this.putNVPair((byte)2, objectID.toLong());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                this.objectIDs.add(new ObjectID(this.getLongValue()));
                return true;
            }
        }
        return false;
    }
}

