/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodesWithKeysResponseMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NodesWithKeysResponseMessageImpl
extends DSOMessageBase
implements NodesWithKeysResponseMessage {
    private static final byte THREAD_ID = 0;
    private static final byte KEY_SET_SIZE = 1;
    private ThreadID threadID;
    private Map<Object, Set<NodeID>> response;

    public NodesWithKeysResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public NodesWithKeysResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initialize(ThreadID tid, Map<Object, Set<NodeID>> resp) {
        this.threadID = tid;
        this.response = resp;
    }

    @Override
    public Map<Object, Set<NodeID>> getNodesWithKeys() {
        return this.response;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public void dehydrateValues() {
        this.putNVPair((byte)0, this.threadID.toLong());
        this.putNVPair((byte)1, this.response.size());
        for (Map.Entry<Object, Set<NodeID>> entry : this.response.entrySet()) {
            TCByteBufferOutputStream out = this.getOutputStream();
            out.writeString(entry.getKey().toString());
            out.writeInt(entry.getValue().size());
            for (NodeID nodeID : entry.getValue()) {
                new NodeIDSerializer(nodeID).serializeTo(out);
            }
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 1: {
                int size = this.getIntValue();
                this.response = new HashMap<Object, Set<NodeID>>(size, 1.0f);
                while (size-- > 0) {
                    String key = this.getInputStream().readString();
                    int setSize = this.getIntValue();
                    HashSet<NodeID> set = new HashSet<NodeID>(setSize, 1.0f);
                    this.response.put(key, set);
                    while (setSize-- > 0) {
                        set.add(this.getNodeIDValue());
                    }
                }
                return true;
            }
        }
        return false;
    }
}

