/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodesWithKeysMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class NodesWithKeysMessageImpl
extends DSOMessageBase
implements NodesWithKeysMessage {
    private static final byte OBJECT_ID = 0;
    private static final byte KEYS_SIZE = 1;
    private static final byte THREAD_ID = 2;
    private ObjectID objectID;
    private Set<Object> keys;
    private ThreadID threadID;

    public NodesWithKeysMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public NodesWithKeysMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public ObjectID getMapObjectID() {
        return this.objectID;
    }

    @Override
    public void setMapObjectID(ObjectID objectID) {
        this.objectID = objectID;
    }

    @Override
    public void setKeys(Set<Object> keys) {
        this.keys = keys;
    }

    @Override
    public Set<Object> getKeys() {
        return this.keys;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public void setThreadID(ThreadID threadID) {
        this.threadID = threadID;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.objectID.toLong());
        this.putNVPair((byte)1, this.keys.size());
        TCByteBufferOutputStream outStream = this.getOutputStream();
        for (Object key : this.keys) {
            outStream.writeString(key.toString());
        }
        this.putNVPair((byte)2, this.threadID.toLong());
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        if (null == this.keys) {
            this.keys = new HashSet<Object>();
        }
        switch (name) {
            case 0: {
                this.objectID = new ObjectID(this.getLongValue());
                return true;
            }
            case 1: {
                int size = this.getIntValue();
                this.keys = new HashSet<Object>(size, 1.0f);
                while (size-- > 0) {
                    this.keys.add(this.getInputStream().readString());
                }
                return true;
            }
            case 2: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
        }
        return false;
    }
}

