/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodeMetaDataResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;

public class NodeMetaDataResponseMessageImpl
extends DSOMessageBase
implements NodeMetaDataResponseMessage {
    private static final byte THREAD_ID = 1;
    private static final byte IP_ID = 2;
    private static final byte HOSTNAME_ID = 3;
    private ThreadID threadID;
    private String ip;
    private String hostname;

    public NodeMetaDataResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public NodeMetaDataResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initialize(ThreadID tID, String theIp, String theHostname) {
        this.threadID = tID;
        this.ip = theIp;
        this.hostname = theHostname;
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        this.putNVPair((byte)1, this.threadID.toLong());
        this.putNVPair((byte)2, this.ip);
        this.putNVPair((byte)3, this.hostname);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                this.ip = this.getStringValue();
                return true;
            }
            case 3: {
                this.hostname = this.getStringValue();
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }
}

