/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.NodeMetaDataMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;

public class NodeMetaDataMessageImpl
extends DSOMessageBase
implements NodeMetaDataMessage {
    private static final byte THREAD_ID = 1;
    private static final byte NODE_ID = 2;
    private ThreadID threadID;
    private NodeID nodeID;

    public NodeMetaDataMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
    }

    public NodeMetaDataMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public void setThreadID(ThreadID threadID) {
        this.threadID = threadID;
    }

    @Override
    public NodeID getNodeID() {
        return this.nodeID;
    }

    @Override
    public void setNodeID(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        Assert.assertNotNull(this.nodeID);
        this.putNVPair((byte)1, this.threadID.toLong());
        this.putNVPair((byte)2, this.nodeID);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                this.nodeID = this.getNodeIDValue();
                return true;
            }
        }
        return false;
    }
}

