/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.async.api.MultiThreadedEventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.RecallBatchContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class LockRequestMessage
extends DSOMessageBase
implements MultiThreadedEventContext {
    private static final byte LOCK_ID = 1;
    private static final byte LOCK_LEVEL = 2;
    private static final byte THREAD_ID = 3;
    private static final byte REQUEST_TYPE = 4;
    private static final byte WAIT_MILLIS = 5;
    private static final byte CONTEXT = 6;
    private static final byte BATCHED_RECALL_CONTEXT = 7;
    private final Set<ClientServerExchangeLockContext> contexts = new LinkedHashSet<ClientServerExchangeLockContext>();
    private final LinkedList<RecallBatchContext> recallContexts = new LinkedList();
    private LockID lockID = null;
    private ServerLockLevel lockLevel = null;
    private ThreadID threadID = null;
    private RequestType requestType = null;
    private long waitMillis = -1L;

    public LockRequestMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public LockRequestMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)4, (byte)this.requestType.ordinal());
        switch (this.requestType) {
            case LOCK: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                this.putNVPair((byte)2, (byte)this.lockLevel.ordinal());
                break;
            }
            case UNLOCK: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                if (this.lockLevel == null) break;
                this.putNVPair((byte)2, (byte)this.lockLevel.ordinal());
                break;
            }
            case TRY_LOCK: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                this.putNVPair((byte)2, (byte)this.lockLevel.ordinal());
                this.putNVPair((byte)5, this.waitMillis);
                break;
            }
            case WAIT: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                this.putNVPair((byte)5, this.waitMillis);
                break;
            }
            case INTERRUPT_WAIT: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                break;
            }
            case QUERY: {
                this.putNVPair((byte)1, this.lockID);
                this.putNVPair((byte)3, this.threadID.toLong());
                break;
            }
            case RECALL_COMMIT: {
                this.putNVPair((byte)1, this.lockID);
                for (ClientServerExchangeLockContext element : this.contexts) {
                    this.putNVPair((byte)6, element);
                }
                break;
            }
            case BATCHED_RECALL_COMMIT: {
                for (RecallBatchContext batchContext : this.recallContexts) {
                    this.putNVPair((byte)7, batchContext);
                }
                break;
            }
        }
    }

    @Override
    protected String describePayload() {
        StringBuffer rv = new StringBuffer();
        rv.append("Request Type: ").append((Object)this.requestType).append('\n');
        rv.append(this.lockID).append(' ').append(this.threadID).append(' ').append("Lock Type: ").append((Object)this.lockLevel).append('\n');
        if (this.waitMillis >= 0L) {
            rv.append("Timeout : ").append(this.waitMillis).append("ms\n");
        }
        if (this.contexts.size() > 0) {
            rv.append("Holder/Waiters/Pending contexts size = ").append(this.contexts.size()).append('\n');
        }
        if (this.recallContexts.size() > 0) {
            rv.append("RecallCommits contexts size = ").append(this.recallContexts.size()).append('\n');
        }
        return rv.toString();
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.lockID = this.getLockIDValue();
                return true;
            }
            case 2: {
                try {
                    this.lockLevel = ServerLockLevel.values()[this.getByteValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                return true;
            }
            case 3: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 4: {
                try {
                    this.requestType = RequestType.values()[this.getByteValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return false;
                }
                return true;
            }
            case 5: {
                this.waitMillis = this.getLongValue();
                return true;
            }
            case 6: {
                this.contexts.add((ClientServerExchangeLockContext)this.getObject(new ClientServerExchangeLockContext()));
                return true;
            }
            case 7: {
                this.recallContexts.add((RecallBatchContext)this.getObject(new RecallBatchContext()));
                return true;
            }
        }
        return false;
    }

    public RequestType getRequestType() {
        return this.requestType;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    public ThreadID getThreadID() {
        return this.threadID;
    }

    public ServerLockLevel getLockLevel() {
        return this.lockLevel;
    }

    public void addContext(ClientServerExchangeLockContext ctxt) {
        Assert.assertTrue(this.contexts.add(ctxt));
    }

    public void addRecallBatchContext(RecallBatchContext recallBatchContext) {
        this.recallContexts.add(recallBatchContext);
    }

    public Collection<ClientServerExchangeLockContext> getContexts() {
        return this.contexts;
    }

    public LinkedList<RecallBatchContext> getRecallBatchedContexts() {
        return this.recallContexts;
    }

    public long getTimeout() {
        return this.waitMillis;
    }

    public void initializeInterruptWait(LockID lid, ThreadID id) {
        this.initialize(lid, id, null, RequestType.INTERRUPT_WAIT, -1L);
    }

    public void initializeQuery(LockID lid, ThreadID id) {
        this.initialize(lid, id, null, RequestType.QUERY, -1L);
    }

    public void initializeLock(LockID lid, ThreadID id, ServerLockLevel level) {
        this.initialize(lid, id, level, RequestType.LOCK, -1L);
    }

    public void initializeTryLock(LockID lid, ThreadID id, long timeout, ServerLockLevel level) {
        this.initialize(lid, id, level, RequestType.TRY_LOCK, timeout);
    }

    public void initializeUnlock(LockID lid, ThreadID id, ServerLockLevel level) {
        this.initialize(lid, id, level, RequestType.UNLOCK, -1L);
    }

    public void initializeWait(LockID lid, ThreadID id, long timeout) {
        this.initialize(lid, id, null, RequestType.WAIT, timeout);
    }

    public void initializeRecallCommit(LockID lid) {
        this.initialize(lid, ThreadID.VM_ID, null, RequestType.RECALL_COMMIT, -1L);
    }

    public void initializeBatchedRecallCommit() {
        this.initialize(null, ThreadID.VM_ID, null, RequestType.BATCHED_RECALL_COMMIT, -1L);
    }

    private void initialize(LockID lid, ThreadID id, ServerLockLevel level, RequestType reqType, long millis) {
        this.lockID = lid;
        this.lockLevel = level;
        this.threadID = id;
        this.requestType = reqType;
        this.waitMillis = millis;
    }

    @Override
    public Object getKey() {
        return this.getSourceNodeID();
    }

    public static enum RequestType {
        LOCK,
        UNLOCK,
        WAIT,
        RECALL_COMMIT,
        QUERY,
        TRY_LOCK,
        INTERRUPT_WAIT,
        BATCHED_RECALL_COMMIT;

    }
}

