/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.serializer.TCObjectOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.KeysForOrphanedValuesResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class KeysForOrphanedValuesResponseMessageImpl
extends DSOMessageBase
implements KeysForOrphanedValuesResponseMessage {
    private static final byte THREAD_ID = 1;
    private static final byte KEYS_DNA_ID = 2;
    private static final byte VALUES_OBJECT_IDS = 3;
    private ThreadID threadID;
    private byte[] keys;
    private Set<ObjectID> valueObjectIDs;

    public KeysForOrphanedValuesResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public KeysForOrphanedValuesResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public void initialize(ThreadID tID, byte[] orphanedKeysDNA) {
        this.threadID = tID;
        this.keys = orphanedKeysDNA;
    }

    @Override
    public void initialize(ThreadID tID, Set<ObjectID> orphanedValuesObjectIDs) {
        this.threadID = tID;
        this.valueObjectIDs = orphanedValuesObjectIDs;
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        Assert.assertTrue("It's not possible to have both the keys of the orphaned values and the orphaned values, it's one or the other and at least one of them is mandatory", this.keys != null && null == this.valueObjectIDs || null == this.keys && this.valueObjectIDs != null);
        this.putNVPair((byte)1, this.threadID.toLong());
        if (this.keys != null) {
            this.putNVPair((byte)2, this.keys);
        }
        if (this.valueObjectIDs != null) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            TCObjectOutputStream objectOut = new TCObjectOutputStream(bytesOut);
            objectOut.writeInt(this.valueObjectIDs.size());
            for (ObjectID objectID : this.valueObjectIDs) {
                objectOut.writeLong(objectID.toLong());
            }
            objectOut.flush();
            this.putNVPair((byte)3, bytesOut.toByteArray());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                this.keys = this.getBytesArray();
                return true;
            }
            case 3: {
                TCByteBufferInputStream input = new TCByteBufferInputStream(TCByteBufferFactory.wrap(this.getBytesArray()));
                HashSet<ObjectID> objectIDs = new HashSet<ObjectID>();
                int size = input.readInt();
                for (int i = 0; i < size; ++i) {
                    objectIDs.add(new ObjectID(input.readLong()));
                }
                this.valueObjectIDs = objectIDs;
                return true;
            }
        }
        return false;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public byte[] getOrphanedKeysDNA() {
        return this.keys;
    }

    @Override
    public Set<ObjectID> getOrphanedValuesObjectIDs() {
        return this.valueObjectIDs;
    }
}

