/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.serializer.TCObjectOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.locks.ThreadID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.KeysForOrphanedValuesMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;

public class KeysForOrphanedValuesMessageImpl
extends DSOMessageBase
implements KeysForOrphanedValuesMessage {
    private static final byte THREAD_ID = 1;
    private static final byte MAP_OBJECT_ID = 2;
    private static final byte VALUES_OBJECT_IDS = 3;
    private ThreadID threadID;
    private ObjectID mapObjectID;
    private Collection<ObjectID> valueObjectIDs;

    public KeysForOrphanedValuesMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
    }

    public KeysForOrphanedValuesMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public ObjectID getMapObjectID() {
        return this.mapObjectID;
    }

    @Override
    public ThreadID getThreadID() {
        return this.threadID;
    }

    @Override
    public Collection<ObjectID> getMapValueObjectIDs() {
        return this.valueObjectIDs;
    }

    @Override
    public void setMapObjectID(ObjectID mapObjectID) {
        this.mapObjectID = mapObjectID;
    }

    @Override
    public void setThreadID(ThreadID threadID) {
        this.threadID = threadID;
    }

    @Override
    public void setMapValueObjectIDs(Collection<ObjectID> objectIDs) {
        this.valueObjectIDs = objectIDs;
    }

    @Override
    protected void dehydrateValues() {
        Assert.assertNotNull(this.threadID);
        Assert.assertTrue("It's not possible to have both an object ID of the map and the object IDs of the map values, it's one or the other and at least one of them is mandatory", this.mapObjectID != null && null == this.valueObjectIDs || null == this.mapObjectID && this.valueObjectIDs != null);
        this.putNVPair((byte)1, this.threadID.toLong());
        if (this.mapObjectID != null) {
            this.putNVPair((byte)2, this.mapObjectID.toLong());
        }
        if (this.valueObjectIDs != null) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            TCObjectOutputStream objectOut = new TCObjectOutputStream(bytesOut);
            objectOut.writeInt(this.valueObjectIDs.size());
            for (ObjectID objectID : this.valueObjectIDs) {
                objectOut.writeLong(objectID.toLong());
            }
            objectOut.flush();
            this.putNVPair((byte)3, bytesOut.toByteArray());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.threadID = new ThreadID(this.getLongValue());
                return true;
            }
            case 2: {
                this.mapObjectID = new ObjectID(this.getLongValue());
                return true;
            }
            case 3: {
                TCByteBufferInputStream input = new TCByteBufferInputStream(TCByteBufferFactory.wrap(this.getBytesArray()));
                HashSet<ObjectID> objectIDs = new HashSet<ObjectID>();
                int size = input.readInt();
                for (int i = 0; i < size; ++i) {
                    objectIDs.add(new ObjectID(input.readLong()));
                }
                this.valueObjectIDs = objectIDs;
                return true;
            }
        }
        return false;
    }
}

