/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.MapSerializer;
import com.tc.object.session.SessionID;
import com.tc.util.BasicObjectIDSet;
import com.tc.util.ObjectIDSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class InvalidateObjectsMessage
extends DSOMessageBase {
    private static final byte INVALIDATIONS = 0;
    private Map<ObjectID, ObjectIDSet> invalidations;

    public InvalidateObjectsMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public InvalidateObjectsMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public void initialize(Map<ObjectID, ObjectIDSet> invalids) {
        this.invalidations = invalids;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, new InvalidationSerializer(this.invalidations));
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.invalidations = (Map)this.getObject(new InvalidationSerializer());
                return true;
            }
        }
        return false;
    }

    public Map<ObjectID, ObjectIDSet> getObjectIDsToInvalidate() {
        return this.invalidations;
    }

    private static class InvalidationSerializer
    extends MapSerializer<ObjectID, ObjectIDSet> {
        public InvalidationSerializer() {
            this((Map<ObjectID, ObjectIDSet>)new HashMap<ObjectID, ObjectIDSet>());
        }

        private InvalidationSerializer(Map<ObjectID, ObjectIDSet> map) {
            super(map);
        }

        @Override
        protected void serializeKey(ObjectID key, TCByteBufferOutput serialOutput) {
            serialOutput.writeLong(key.toLong());
        }

        @Override
        protected void serializeValue(ObjectIDSet value, TCByteBufferOutput serialOutput) {
            value.serializeTo(serialOutput);
        }

        @Override
        protected ObjectID deserializeKey(TCByteBufferInput serialInput) throws IOException {
            return new ObjectID(serialInput.readLong());
        }

        @Override
        protected ObjectIDSet deserializeValue(TCByteBufferInput serialInput) throws IOException {
            return (ObjectIDSet)new BasicObjectIDSet().deserializeFrom(serialInput);
        }
    }
}

