/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.msg.IndexQueryResultSerializer;
import com.terracottatech.search.GroupedIndexQueryResultImpl;
import com.terracottatech.search.GroupedQueryResult;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.aggregator.AbstractAggregator;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GroupedQueryResultSerializer
extends IndexQueryResultSerializer<GroupedQueryResult> {
    @Override
    public void serialize(GroupedQueryResult result, TCByteBufferOutput output) {
        output.writeInt(result.getGroupedAttributes().size());
        for (NVPair pair : result.getGroupedAttributes()) {
            NVPAIR_SERIALIZER.serialize(pair, output, NULL_SERIALIZER);
        }
        output.writeInt(result.getAggregators().size());
        for (Aggregator agg : result.getAggregators()) {
            try {
                agg.serializeTo((DataOutput)output);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.serialize(result, output);
    }

    @Override
    GroupedQueryResult deserializeFrom(TCByteBufferInput input) throws IOException {
        int size = input.readInt();
        HashSet<NVPair> groupByAttributes = new HashSet<NVPair>(size);
        for (int i = 0; i < size; ++i) {
            NVPair pair = NVPAIR_SERIALIZER.deserialize(input, NULL_SERIALIZER);
            groupByAttributes.add(pair);
        }
        int aggregatorCount = input.readInt();
        ArrayList<Aggregator> aggregators = new ArrayList<Aggregator>(aggregatorCount);
        for (int i = 0; i < aggregatorCount; ++i) {
            Aggregator aggregator = AbstractAggregator.deserializeInstance((DataInput)input);
            aggregators.add(aggregator);
        }
        GroupedResultBuilder builder = (GroupedResultBuilder)this.buildCommonFields(input);
        return builder.setAggregators(aggregators).setGroupByAttributes(groupByAttributes).build();
    }

    @Override
    protected IndexQueryResultSerializer.IndexQueryResultBuilder builder() {
        return new GroupedResultBuilder();
    }

    private final class GroupedResultBuilder
    extends IndexQueryResultSerializer.IndexQueryResultBuilder {
        private List<Aggregator> aggregators;
        private Set<NVPair> groupByAttributes;

        private GroupedResultBuilder() {
        }

        protected GroupedQueryResult build() {
            return new GroupedIndexQueryResultImpl(this.attributes, this.sortAttributes, this.groupByAttributes, this.aggregators);
        }

        private GroupedResultBuilder setAggregators(List<Aggregator> aggregators) {
            this.aggregators = aggregators;
            return this;
        }

        private GroupedResultBuilder setGroupByAttributes(Set<NVPair> groupByAttributes) {
            this.groupByAttributes = groupByAttributes;
            return this;
        }
    }
}

