/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.CompoundResponse;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapGetValueResponse;
import com.tc.object.ServerMapRequestID;
import com.tc.object.ServerMapRequestType;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.impl.ObjectDNAImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.GetValueServerMapResponseMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class GetValueServerMapResponseMessageImpl
extends DSOMessageBase
implements GetValueServerMapResponseMessage {
    private static final byte MAP_OBJECT_ID = 0;
    private static final byte RESPONSES_SIZE = 1;
    private static final byte SERIALIZER_ID = 2;
    private static final byte OBJECT_ID = 3;
    private static final byte DNA_ID = 4;
    private static final DNAEncoding encoder = new StorageDNAEncodingImpl();
    private final DNAEncoding decoder;
    private ObjectID mapID;
    private Collection<ServerMapGetValueResponse> responses;
    private ObjectStringSerializer serializer;

    public GetValueServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data, DNAEncoding decoder) {
        super(sessionID, monitor, channel, header, data);
        this.decoder = decoder;
    }

    public GetValueServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
        this.decoder = null;
    }

    @Override
    public void initializeGetValueResponse(ObjectID mapObjectID, ObjectStringSerializer serializer, Collection<ServerMapGetValueResponse> getValueResponses) {
        this.responses = getValueResponses;
        this.serializer = serializer;
        this.mapID = mapObjectID;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.mapID.toLong());
        this.putNVPair((byte)2, this.serializer);
        this.putNVPair((byte)1, this.responses.size());
        TCByteBufferOutputStream outStream = this.getOutputStream();
        for (ServerMapGetValueResponse r : this.responses) {
            outStream.writeLong(r.getRequestID().toLong());
            outStream.writeInt(r.getValues().size());
            for (Map.Entry<Object, Object> entry : r.getValues().entrySet()) {
                encoder.encode(entry.getKey(), outStream);
                CompoundResponse responseValue = (CompoundResponse)entry.getValue();
                Object value = responseValue.getData();
                if (value instanceof ObjectID) {
                    outStream.writeByte(3);
                    outStream.writeLong(((ObjectID)value).toLong());
                } else {
                    TCByteBufferOutputStream list = (TCByteBufferOutputStream)value;
                    outStream.writeByte(4);
                    outStream.writeInt(list.getBytesWritten());
                    outStream.write(list.toArray());
                }
                encoder.encode(responseValue.getCreationTime(), outStream);
                encoder.encode(responseValue.getLastAccessedTime(), outStream);
                encoder.encode(responseValue.getTimeToIdle(), outStream);
                encoder.encode(responseValue.getTimeToLive(), outStream);
                encoder.encode(responseValue.getVersion(), outStream);
            }
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.mapID = new ObjectID(this.getLongValue());
                return true;
            }
            case 2: {
                this.serializer = (ObjectStringSerializer)this.getObject(new ObjectStringSerializerImpl());
                return true;
            }
            case 1: {
                int size = this.getIntValue();
                this.responses = new ArrayList<ServerMapGetValueResponse>(size);
                TCByteBufferInputStream inputStream = this.getInputStream();
                while (size-- > 0) {
                    try {
                        long responseId = this.getLongValue();
                        int numResponses = this.getIntValue();
                        ServerMapGetValueResponse response = new ServerMapGetValueResponse(new ServerMapRequestID(responseId));
                        for (int i = 0; i < numResponses; ++i) {
                            Object key = this.decoder.decode(inputStream);
                            byte type = inputStream.readByte();
                            if (type == 3) {
                                response.put(key, new ObjectID(inputStream.readLong()), false, (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream));
                                continue;
                            }
                            if (type != 4) {
                                throw new AssertionError((Object)"bad type");
                            }
                            int length = inputStream.readInt();
                            byte[] grab = new byte[length];
                            inputStream.readFully(grab);
                            ObjectDNAImpl value = new ObjectDNAImpl(this.serializer, false);
                            value.deserializeFrom(new TCByteBufferInputStream(TCByteBufferFactory.wrap(grab)));
                            response.put(key, value.getObjectID(), true, (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream), (Long)this.decoder.decode(inputStream));
                            response.replace(value.getObjectID(), value);
                        }
                        this.responses.add(response);
                    }
                    catch (ClassNotFoundException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ObjectID getMapID() {
        return this.mapID;
    }

    @Override
    public Collection<ServerMapGetValueResponse> getGetValueResponses() {
        return this.responses;
    }

    @Override
    public ServerMapRequestType getRequestType() {
        return ServerMapRequestType.GET_VALUE_FOR_KEY;
    }
}

