/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapGetValueRequest;
import com.tc.object.ServerMapRequestID;
import com.tc.object.ServerMapRequestType;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.impl.SerializerDNAEncodingImpl;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.GetValueServerMapRequestMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GetValueServerMapRequestMessageImpl
extends DSOMessageBase
implements GetValueServerMapRequestMessage {
    private static final byte REQUESTS_COUNT = 0;
    private static final byte MAP_ID = 1;
    private static final DNAEncoding encoder = new SerializerDNAEncodingImpl();
    private static final DNAEncoding decoder = new StorageDNAEncodingImpl();
    private final Map<ObjectID, Collection<ServerMapGetValueRequest>> requests = new HashMap<ObjectID, Collection<ServerMapGetValueRequest>>();
    private int requestsCount;

    public GetValueServerMapRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public GetValueServerMapRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    @Override
    public void addGetValueRequestTo(ServerMapRequestID serverMapRequestID, ObjectID id, Set<Object> keys) {
        Collection<ServerMapGetValueRequest> requestsForMap = this.requests.get(id);
        if (requestsForMap == null) {
            requestsForMap = new ArrayList<ServerMapGetValueRequest>();
            this.requests.put(id, requestsForMap);
        }
        requestsForMap.add(new ServerMapGetValueRequest(serverMapRequestID, keys));
        ++this.requestsCount;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.requestsCount);
        int count = 0;
        TCByteBufferOutputStream outStream = this.getOutputStream();
        for (Map.Entry<ObjectID, Collection<ServerMapGetValueRequest>> e : this.requests.entrySet()) {
            ObjectID mapID = e.getKey();
            this.putNVPair((byte)1, mapID.toLong());
            Collection<ServerMapGetValueRequest> requests4Map = e.getValue();
            outStream.writeInt(requests4Map.size());
            for (ServerMapGetValueRequest svr : e.getValue()) {
                outStream.writeLong(svr.getRequestID().toLong());
                outStream.writeInt(svr.getKeys().size());
                for (Object key : svr.getKeys()) {
                    encoder.encode(key, outStream);
                }
                ++count;
            }
        }
        Assert.assertEquals(this.requestsCount, count);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.requestsCount = this.getIntValue();
                return true;
            }
            case 1: {
                ObjectID mapID = new ObjectID(this.getLongValue());
                ArrayList<ServerMapGetValueRequest> requests4Map = new ArrayList<ServerMapGetValueRequest>();
                int count = this.getIntValue();
                while (count-- > 0) {
                    try {
                        long requestId = this.getLongValue();
                        int keySize = this.getIntValue();
                        HashSet<Object> keys = new HashSet<Object>();
                        for (int i = 0; i < keySize; ++i) {
                            keys.add(decoder.decode(this.getInputStream()));
                        }
                        requests4Map.add(new ServerMapGetValueRequest(new ServerMapRequestID(requestId), keys));
                    }
                    catch (ClassNotFoundException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                Collection old = this.requests.put(mapID, requests4Map);
                Assert.assertNull(old);
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<ObjectID, Collection<ServerMapGetValueRequest>> getRequests() {
        return this.requests;
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getSourceNodeID();
    }

    @Override
    public ServerMapRequestType getRequestType() {
        return ServerMapRequestType.GET_VALUE_FOR_KEY;
    }

    @Override
    public int getRequestCount() {
        return this.requestsCount;
    }
}

