/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapRequestID;
import com.tc.object.ServerMapRequestType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.GetAllSizeServerMapRequestMessage;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class GetAllSizeServerMapRequestMessageImpl
extends DSOMessageBase
implements GetAllSizeServerMapRequestMessage {
    private static final byte MAP_OBJECT_IDS = 0;
    private static final byte REQUEST_ID = 1;
    private ObjectID[] mapIDs;
    private ServerMapRequestID requestID;

    public GetAllSizeServerMapRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public GetAllSizeServerMapRequestMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    @Override
    public void initializeGetAllSizeRequest(ServerMapRequestID serverMapRequestID, ObjectID[] maps) {
        this.requestID = serverMapRequestID;
        this.mapIDs = maps;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.requestID.toLong());
        TCByteBufferOutputStream outStream = this.getOutputStream();
        this.putNVPair((byte)0, this.mapIDs.length);
        for (ObjectID oid : this.mapIDs) {
            outStream.writeLong(oid.toLong());
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                int length = this.getIntValue();
                this.mapIDs = new ObjectID[length];
                for (int i = 0; i < length; ++i) {
                    this.mapIDs[i] = new ObjectID(this.getLongValue());
                }
                return true;
            }
            case 1: {
                this.requestID = new ServerMapRequestID(this.getLongValue());
                return true;
            }
        }
        return false;
    }

    @Override
    public ClientID getClientID() {
        return (ClientID)this.getSourceNodeID();
    }

    @Override
    public ObjectID[] getMaps() {
        return this.mapIDs;
    }

    @Override
    public ServerMapRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public ServerMapRequestType getRequestType() {
        return ServerMapRequestType.GET_SIZE;
    }

    @Override
    public int getRequestCount() {
        return 1;
    }
}

