/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapRequestID;
import com.tc.object.ServerMapRequestType;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.GetAllKeysServerMapResponseMessage;
import com.tc.object.session.SessionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GetAllKeysServerMapResponseMessageImpl
extends DSOMessageBase
implements GetAllKeysServerMapResponseMessage {
    private static final byte MAP_OBJECT_ID = 0;
    private static final byte REQUEST_ID = 1;
    private static final byte GET_ALL_KEYS_SIZE = 2;
    private ObjectID mapID;
    private ServerMapRequestID requestID;
    private Set keys;
    private static final DNAEncoding encoder = new StorageDNAEncodingImpl();
    private final DNAEncoding decoder;

    public GetAllKeysServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data, DNAEncoding decoder) {
        super(sessionID, monitor, channel, header, data);
        this.decoder = decoder;
    }

    public GetAllKeysServerMapResponseMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
        this.decoder = null;
    }

    @Override
    public void initializeGetAllKeysResponse(ObjectID mapObjectID, ServerMapRequestID serverMapRequestID, Set set) {
        this.keys = set;
        this.mapID = mapObjectID;
        this.requestID = serverMapRequestID;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)0, this.mapID.toLong());
        this.putNVPair((byte)1, this.requestID.toLong());
        this.putNVPair((byte)2, this.keys.size());
        int count = 0;
        TCByteBufferOutputStream outStream = this.getOutputStream();
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            encoder.encode(iter.next(), outStream);
            ++count;
        }
        Assert.assertEquals(this.keys.size(), count);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.mapID = new ObjectID(this.getLongValue());
                return true;
            }
            case 1: {
                this.requestID = new ServerMapRequestID(this.getLongValue());
                return true;
            }
            case 2: {
                int size = this.getIntValue();
                this.keys = new HashSet((int)((double)size * 1.5));
                TCByteBufferInputStream inputStream = this.getInputStream();
                while (size-- > 0) {
                    try {
                        Object key = this.decoder.decode(inputStream);
                        this.keys.add(key);
                    }
                    catch (ClassNotFoundException e) {
                        throw new AssertionError((Object)e);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ObjectID getMapID() {
        return this.mapID;
    }

    @Override
    public ServerMapRequestID getRequestID() {
        return this.requestID;
    }

    @Override
    public Set getAllKeys() {
        return this.keys;
    }

    @Override
    public ServerMapRequestType getRequestType() {
        return ServerMapRequestType.GET_ALL_KEYS;
    }
}

