/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.async.api.EventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.lang.Recyclable;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.msg.CommitTransactionMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionBatch;
import java.io.IOException;

public class CommitTransactionMessageImpl
extends DSOMessageBase
implements EventContext,
CommitTransactionMessage {
    private static final byte BATCH_TRANSACTION_DATA_ID = 1;
    private static final byte SERIALIZER_ID = 2;
    private Recyclable batch;
    private TCByteBuffer[] batchData;
    private ObjectStringSerializer serializer;

    public CommitTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public CommitTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public ObjectStringSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)2, this.serializer);
        this.putNVPair((byte)1, this.batchData);
        this.batchData = null;
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.batchData = this.getInputStream().toArray();
                return true;
            }
            case 2: {
                this.serializer = (ObjectStringSerializer)this.getObject(new ObjectStringSerializerImpl());
                return true;
            }
        }
        return false;
    }

    @Override
    public void setBatch(TransactionBatch batch, ObjectStringSerializer serializer) {
        this.batch = batch;
        if (this.batchData != null) {
            throw new AssertionError((Object)"Attempt to set TransactionBatch more than once.");
        }
        this.batchData = batch.getData();
        this.serializer = serializer;
    }

    @Override
    public TCByteBuffer[] getBatchData() {
        return this.batchData;
    }

    @Override
    public void doRecycleOnRead() {
    }

    @Override
    protected boolean isOutputStreamRecycled() {
        return true;
    }

    @Override
    public void doRecycleOnWrite() {
        this.recycleOutputStream();
        if (this.batch != null) {
            this.batch.recycle();
        }
    }
}

