/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.BasicObjectIDSet;
import com.tc.util.ObjectIDSet;
import com.tc.util.SequenceID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ClientHandshakeMessageImpl
extends DSOMessageBase
implements ClientHandshakeMessage {
    private static final byte MANAGED_OBJECT_IDS = 1;
    private static final byte LOCK_CONTEXT = 2;
    private static final byte TRANSACTION_SEQUENCE_IDS = 3;
    private static final byte RESENT_TRANSACTION_IDS = 4;
    private static final byte REQUEST_OBJECT_IDS = 5;
    private static final byte CLIENT_VERSION = 6;
    private static final byte SERVER_HIGH_WATER_MARK = 7;
    private static final byte ENTERPRISE_CLIENT = 8;
    private static final byte OBJECTS_TO_VALIDATE = 9;
    private static final byte LOCAL_TIME_MILLS = 10;
    private final Set<ClientServerExchangeLockContext> lockContexts = new HashSet<ClientServerExchangeLockContext>();
    private final List<SequenceID> sequenceIDs = new ArrayList<SequenceID>();
    private final List<TransactionID> txnIDs = new ArrayList<TransactionID>();
    private ObjectIDSet objectsToValidate = new BasicObjectIDSet();
    private ObjectIDSet objectIDs = new BasicObjectIDSet();
    private long currentLocalTimeMills = System.currentTimeMillis();
    private boolean requestObjectIDs;
    private boolean enterpriseClient = false;
    private long serverHighWaterMark = 0L;
    private String clientVersion = "UNKNOW";

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType messageType) {
        super(sessionID, monitor, out, channel, messageType);
    }

    public ClientHandshakeMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    public Collection<ClientServerExchangeLockContext> getLockContexts() {
        return this.lockContexts;
    }

    @Override
    public ObjectIDSet getObjectIDs() {
        return this.objectIDs;
    }

    @Override
    public void setObjectIDs(ObjectIDSet objectIDs) {
        this.objectIDs = objectIDs;
    }

    @Override
    public ObjectIDSet getObjectIDsToValidate() {
        return this.objectsToValidate;
    }

    @Override
    public void setObjectIDsToValidate(ObjectIDSet objectIDsToValidate) {
        this.objectsToValidate = objectIDsToValidate;
    }

    @Override
    public List<SequenceID> getTransactionSequenceIDs() {
        return this.sequenceIDs;
    }

    @Override
    public List<TransactionID> getResentTransactionIDs() {
        return this.txnIDs;
    }

    @Override
    public boolean isObjectIDsRequested() {
        return this.requestObjectIDs;
    }

    @Override
    public String getClientVersion() {
        return this.clientVersion;
    }

    @Override
    public void addTransactionSequenceIDs(List<SequenceID> seqIDs) {
        this.sequenceIDs.addAll(seqIDs);
    }

    @Override
    public void addResentTransactionIDs(List<TransactionID> resentTransactionIDs) {
        this.txnIDs.addAll(resentTransactionIDs);
    }

    @Override
    public void setIsObjectIDsRequested(boolean request) {
        this.requestObjectIDs = request;
    }

    @Override
    public void setClientVersion(String version) {
        this.clientVersion = version;
    }

    @Override
    public void addLockContext(ClientServerExchangeLockContext ctxt) {
        this.lockContexts.add(ctxt);
    }

    @Override
    public long getServerHighWaterMark() {
        return this.serverHighWaterMark;
    }

    @Override
    public void setServerHighWaterMark(long serverHWM) {
        this.serverHighWaterMark = serverHWM;
    }

    @Override
    public boolean enterpriseClient() {
        return this.enterpriseClient;
    }

    @Override
    public void setEnterpriseClient(boolean isEnterpriseClient) {
        this.enterpriseClient = isEnterpriseClient;
    }

    @Override
    public long getLocalTimeMills() {
        return this.currentLocalTimeMills;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.objectIDs);
        this.putNVPair((byte)9, this.objectsToValidate);
        for (ClientServerExchangeLockContext lockContext : this.lockContexts) {
            this.putNVPair((byte)2, lockContext);
        }
        for (SequenceID sequenceID : this.sequenceIDs) {
            this.putNVPair((byte)3, sequenceID);
        }
        for (TransactionID txnID : this.txnIDs) {
            this.putNVPair((byte)4, txnID);
        }
        this.putNVPair((byte)5, this.requestObjectIDs);
        this.putNVPair((byte)8, this.enterpriseClient);
        this.putNVPair((byte)6, this.clientVersion);
        this.putNVPair((byte)7, this.serverHighWaterMark);
        this.putNVPair((byte)10, this.currentLocalTimeMills);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.objectIDs = (ObjectIDSet)this.getObject(new BasicObjectIDSet());
                return true;
            }
            case 9: {
                this.objectsToValidate = (ObjectIDSet)this.getObject(new BasicObjectIDSet());
                return true;
            }
            case 2: {
                this.lockContexts.add((ClientServerExchangeLockContext)this.getObject(new ClientServerExchangeLockContext()));
                return true;
            }
            case 3: {
                this.sequenceIDs.add(new SequenceID(this.getLongValue()));
                return true;
            }
            case 4: {
                this.txnIDs.add(new TransactionID(this.getLongValue()));
                return true;
            }
            case 5: {
                this.requestObjectIDs = this.getBooleanValue();
                return true;
            }
            case 8: {
                this.enterpriseClient = this.getBooleanValue();
                return true;
            }
            case 6: {
                this.clientVersion = this.getStringValue();
                return true;
            }
            case 7: {
                this.serverHighWaterMark = this.getLongValue();
                return true;
            }
            case 10: {
                this.currentLocalTimeMills = this.getLongValue();
                return true;
            }
        }
        return false;
    }
}

