/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.ClientID;
import com.tc.net.GroupID;
import com.tc.net.StripeID;
import com.tc.net.groups.GroupToStripeMapSerializer;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClientHandshakeAckMessageImpl
extends DSOMessageBase
implements ClientHandshakeAckMessage {
    private static final byte PERSISTENT_SERVER = 1;
    private static final byte ALL_NODES = 2;
    private static final byte THIS_NODE_ID = 3;
    private static final byte SERVER_VERSION = 4;
    private static final byte GROUP_ID = 5;
    private static final byte STRIPE_ID = 6;
    private static final byte STRIPE_ID_MAP = 7;
    private final Set<ClientID> allNodes = new HashSet<ClientID>();
    private boolean persistentServer;
    private ClientID thisNodeId;
    private String serverVersion;
    private GroupID groupID;
    private StripeID stripeID;
    private Map<GroupID, StripeID> stripeIDMap = new HashMap<GroupID, StripeID>(0);

    public ClientHandshakeAckMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public ClientHandshakeAckMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.persistentServer);
        for (ClientID clientID : this.allNodes) {
            this.putNVPair((byte)2, clientID);
        }
        this.putNVPair((byte)3, this.thisNodeId);
        this.putNVPair((byte)4, this.serverVersion);
        this.putNVPair((byte)5, this.groupID);
        this.putNVPair((byte)6, this.stripeID);
        this.putNVPair((byte)7, new GroupToStripeMapSerializer(this.stripeIDMap));
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.persistentServer = this.getBooleanValue();
                return true;
            }
            case 2: {
                this.allNodes.add((ClientID)this.getNodeIDValue());
                return true;
            }
            case 3: {
                this.thisNodeId = (ClientID)this.getNodeIDValue();
                return true;
            }
            case 4: {
                this.serverVersion = this.getStringValue();
                return true;
            }
            case 5: {
                this.groupID = (GroupID)this.getNodeIDValue();
                return true;
            }
            case 6: {
                this.stripeID = (StripeID)this.getNodeIDValue();
                return true;
            }
            case 7: {
                this.stripeIDMap = ((GroupToStripeMapSerializer)this.getObject(new GroupToStripeMapSerializer())).getMap();
                return true;
            }
        }
        return false;
    }

    @Override
    public void initialize(boolean persistent, Set<ClientID> allNodeIDs, ClientID thisNodeID, String sv, GroupID l2GroupID, StripeID l2StripeID, Map<GroupID, StripeID> sidMap) {
        this.persistentServer = persistent;
        this.allNodes.addAll(allNodeIDs);
        this.thisNodeId = thisNodeID;
        this.serverVersion = sv;
        this.groupID = l2GroupID;
        this.stripeID = l2StripeID;
        this.stripeIDMap = sidMap;
    }

    @Override
    public boolean getPersistentServer() {
        return this.persistentServer;
    }

    @Override
    public ClientID[] getAllNodes() {
        return this.allNodes.toArray(new ClientID[0]);
    }

    @Override
    public ClientID getThisNodeId() {
        return this.thisNodeId;
    }

    @Override
    public String getServerVersion() {
        return this.serverVersion;
    }

    @Override
    public GroupID getGroupID() {
        return this.groupID;
    }

    @Override
    public StripeID getStripeID() {
        return this.stripeID;
    }

    @Override
    public Map<GroupID, StripeID> getStripeIDMap() {
        return this.stripeIDMap;
    }
}

