/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNA;
import com.tc.object.dna.api.LogicalChangeID;
import com.tc.object.dna.api.LogicalChangeResult;
import com.tc.object.dna.impl.DNAImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.dna.impl.VersionizedDNAWrapper;
import com.tc.object.gtx.GlobalTransactionID;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.msg.BroadcastTransactionMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.msg.ServerEventSerializableContext;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.object.tx.TxnType;
import com.tc.server.ServerEvent;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BroadcastTransactionMessageImpl
extends DSOMessageBase
implements BroadcastTransactionMessage {
    private static final byte DNA_ID = 1;
    private static final byte LOCK_ID = 2;
    private static final byte CHANGE_ID = 3;
    private static final byte TRANSACTION_ID = 4;
    private static final byte COMMITTER_ID = 5;
    private static final byte TRANSACTION_TYPE_ID = 6;
    private static final byte GLOBAL_TRANSACTION_ID = 7;
    private static final byte LOW_WATERMARK = 8;
    private static final byte SERIALIZER_ID = 9;
    private static final byte NOTIFIED = 10;
    private static final byte ROOT_NAME_ID_PAIR = 11;
    private static final byte LOGICAL_CHANGE_RESULT = 13;
    private static final byte SERVER_EVENT = 14;
    private long changeID;
    private TransactionID transactionID;
    private NodeID committerID;
    private TxnType transactionType;
    private GlobalTransactionID globalTransactionID;
    private GlobalTransactionID lowWatermark;
    private ObjectStringSerializer serializer;
    private final List changes = new ArrayList();
    private final Collection notifies = new ArrayList();
    private final Map newRoots = new HashMap();
    private final List<LockID> lockIDs = new ArrayList<LockID>();
    private final Map<LogicalChangeID, LogicalChangeResult> logicalChangeResults = new HashMap<LogicalChangeID, LogicalChangeResult>();
    private final List<ServerEvent> events = new ArrayList<ServerEvent>();

    public BroadcastTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public BroadcastTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)6, this.transactionType.getType());
        Iterator<Object> iterator = this.lockIDs.iterator();
        while (iterator.hasNext()) {
            LockID lockID;
            LockID lockID2 = lockID = iterator.next();
            this.putNVPair((byte)2, lockID2);
        }
        for (LockID lockID : this.notifies) {
            ClientServerExchangeLockContext notified = (ClientServerExchangeLockContext)((Object)lockID);
            this.putNVPair((byte)10, notified);
        }
        this.putNVPair((byte)9, this.serializer);
        this.putNVPair((byte)3, this.changeID);
        this.putNVPair((byte)4, this.transactionID.toLong());
        this.putNVPair((byte)5, this.committerID);
        this.putNVPair((byte)7, this.globalTransactionID.toLong());
        this.putNVPair((byte)8, this.lowWatermark.toLong());
        for (LockID lockID : this.changes) {
            DNAImpl dna = (DNAImpl)((Object)lockID);
            this.putNVPair((byte)1, dna);
        }
        for (LockID lockID : this.newRoots.keySet()) {
            String key = (String)((Object)lockID);
            ObjectID value = (ObjectID)this.newRoots.get(key);
            this.putNVPair((byte)11, new RootIDPair(key, value));
        }
        for (Map.Entry entry : this.logicalChangeResults.entrySet()) {
            this.putNVPair((byte)13, new LogicalChangeResultPair((LogicalChangeID)entry.getKey(), (LogicalChangeResult)entry.getValue()));
        }
        for (ServerEvent serverEvent : this.events) {
            this.putNVPair((byte)14, new ServerEventSerializableContext(serverEvent));
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 6: {
                this.transactionType = TxnType.typeFor(this.getByteValue());
                return true;
            }
            case 1: {
                this.changes.add(this.getObject(new DNAImpl(this.serializer, false)));
                return true;
            }
            case 9: {
                this.serializer = (ObjectStringSerializer)this.getObject(new ObjectStringSerializerImpl());
                return true;
            }
            case 2: {
                this.lockIDs.add(this.getLockIDValue());
                return true;
            }
            case 10: {
                this.notifies.add(this.getObject(new ClientServerExchangeLockContext()));
                return true;
            }
            case 3: {
                this.changeID = this.getLongValue();
                return true;
            }
            case 4: {
                this.transactionID = new TransactionID(this.getLongValue());
                return true;
            }
            case 5: {
                this.committerID = this.getNodeIDValue();
                return true;
            }
            case 7: {
                this.globalTransactionID = new GlobalTransactionID(this.getLongValue());
                return true;
            }
            case 8: {
                this.lowWatermark = new GlobalTransactionID(this.getLongValue());
                return true;
            }
            case 11: {
                RootIDPair rootIDPair = (RootIDPair)this.getObject(new RootIDPair());
                this.newRoots.put(rootIDPair.getRootName(), rootIDPair.getRootID());
                return true;
            }
            case 13: {
                LogicalChangeResultPair resultPair = (LogicalChangeResultPair)this.getObject(new LogicalChangeResultPair());
                this.logicalChangeResults.put(resultPair.getId(), resultPair.getResult());
                return true;
            }
            case 14: {
                ServerEventSerializableContext ctx = (ServerEventSerializableContext)this.getObject(new ServerEventSerializableContext());
                this.events.add(ctx.getEvent());
                return true;
            }
        }
        return false;
    }

    @Override
    public void initialize(List chges, ObjectStringSerializer aSerializer, LockID[] lids, long cid, TransactionID txID, NodeID client, GlobalTransactionID gtx, TxnType txnType, GlobalTransactionID lowGlobalTransactionIDWatermark, Collection theNotifies, Map roots, Map<LogicalChangeID, LogicalChangeResult> logicalInvokeResults, Collection<ServerEvent> events) {
        Assert.assertNotNull(txnType);
        this.changes.addAll(chges);
        Collections.addAll(this.lockIDs, lids);
        this.changeID = cid;
        this.transactionID = txID;
        this.committerID = client;
        this.transactionType = txnType;
        this.globalTransactionID = gtx;
        this.lowWatermark = lowGlobalTransactionIDWatermark;
        this.serializer = aSerializer;
        this.notifies.addAll(theNotifies);
        this.newRoots.putAll(roots);
        this.logicalChangeResults.putAll(logicalInvokeResults);
        this.events.addAll(events);
    }

    @Override
    public List getLockIDs() {
        return this.lockIDs;
    }

    @Override
    public TxnType getTransactionType() {
        return this.transactionType;
    }

    @Override
    public Collection getObjectChanges() {
        ArrayList<VersionizedDNAWrapper<DNA>> versionizedChanges = new ArrayList<VersionizedDNAWrapper<DNA>>(this.changes.size());
        for (Object change : this.changes) {
            versionizedChanges.add(new VersionizedDNAWrapper<DNA>((DNA)change, this.globalTransactionID.toLong()));
        }
        return versionizedChanges;
    }

    @Override
    public long getChangeID() {
        return this.changeID;
    }

    @Override
    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    @Override
    public NodeID getCommitterID() {
        return this.committerID;
    }

    @Override
    public GlobalTransactionID getGlobalTransactionID() {
        return this.globalTransactionID;
    }

    @Override
    public GlobalTransactionID getLowGlobalTransactionIDWatermark() {
        Assert.assertNotNull(this.lowWatermark);
        return this.lowWatermark;
    }

    @Override
    public Collection getNotifies() {
        return new ArrayList(this.notifies);
    }

    @Override
    public void doRecycleOnRead() {
    }

    @Override
    protected boolean isOutputStreamRecycled() {
        return true;
    }

    @Override
    public void doRecycleOnWrite() {
        this.recycleOutputStream();
    }

    @Override
    public Map getNewRoots() {
        return this.newRoots;
    }

    public Map<LogicalChangeID, LogicalChangeResult> getLogicalChangeResults() {
        return this.logicalChangeResults;
    }

    @Override
    public List<ServerEvent> getEvents() {
        return this.events;
    }

    private static class LogicalChangeResultPair
    implements TCSerializable {
        private LogicalChangeID id;
        private LogicalChangeResult result;

        public LogicalChangeResultPair(LogicalChangeID id, LogicalChangeResult result) {
            this.id = id;
            this.result = result;
        }

        public LogicalChangeResultPair() {
        }

        @Override
        public void serializeTo(TCByteBufferOutput serialOutput) {
            serialOutput.writeLong(this.id.toLong());
            this.result.serializeTo(serialOutput);
        }

        @Override
        public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
            this.id = new LogicalChangeID(serialInput.readLong());
            this.result = (LogicalChangeResult)new LogicalChangeResult().deserializeFrom(serialInput);
            return this;
        }

        public LogicalChangeID getId() {
            return this.id;
        }

        public LogicalChangeResult getResult() {
            return this.result;
        }
    }

    private static class RootIDPair
    implements TCSerializable {
        private String rootName;
        private ObjectID rootID;

        public RootIDPair() {
        }

        public RootIDPair(String rootName, ObjectID rootID) {
            this.rootName = rootName;
            this.rootID = rootID;
        }

        @Override
        public void serializeTo(TCByteBufferOutput serialOutput) {
            serialOutput.writeString(this.rootName);
            serialOutput.writeLong(this.rootID.toLong());
        }

        @Override
        public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
            this.rootName = serialInput.readString();
            this.rootID = new ObjectID(serialInput.readLong());
            return this;
        }

        public ObjectID getRootID() {
            return this.rootID;
        }

        public String getRootName() {
            return this.rootName;
        }
    }
}

