/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.msg;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.NodeID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.AcknowledgeTransactionMessage;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import java.io.IOException;

public class AcknowledgeTransactionMessageImpl
extends DSOMessageBase
implements AcknowledgeTransactionMessage {
    private static final byte REQUEST_ID = 1;
    private static final byte REQUESTER_ID = 2;
    private TransactionID requestID;
    private NodeID requesterID;

    public AcknowledgeTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public AcknowledgeTransactionMessageImpl(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.requestID.toLong());
        this.putNVPair((byte)2, this.requesterID);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 2: {
                this.requesterID = this.getNodeIDValue();
                return true;
            }
            case 1: {
                this.requestID = new TransactionID(this.getLongValue());
                return true;
            }
        }
        return false;
    }

    @Override
    public void initialize(NodeID nid, TransactionID txID) {
        this.requesterID = nid;
        this.requestID = txID;
    }

    @Override
    public NodeID getRequesterID() {
        return this.requesterID;
    }

    @Override
    public TransactionID getRequestID() {
        return this.requestID;
    }
}

