/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.metadata;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Date;

public class NVPairSerializer {
    private static final ValueType[] ALL_TYPES = ValueType.values();

    public void serialize(NVPair nvPair, TCByteBufferOutput out, ObjectStringSerializer stringSerializer) {
        stringSerializer.writeString(out, nvPair.getName());
        ValueType type = nvPair.getType();
        out.writeByte(type.ordinal());
        switch (type) {
            case BOOLEAN: {
                out.writeBoolean(((AbstractNVPair.BooleanNVPair)nvPair).getValue());
                return;
            }
            case BYTE: {
                out.writeByte(((AbstractNVPair.ByteNVPair)nvPair).getValue());
                return;
            }
            case BYTE_ARRAY: {
                byte[] val = ((AbstractNVPair.ByteArrayNVPair)nvPair).getValue();
                out.writeInt(val.length);
                out.write(val);
                return;
            }
            case CHAR: {
                out.writeChar(((AbstractNVPair.CharNVPair)nvPair).getValue());
                return;
            }
            case DATE: {
                out.writeLong(((AbstractNVPair.DateNVPair)nvPair).getValue().getTime());
                return;
            }
            case DOUBLE: {
                out.writeDouble(((AbstractNVPair.DoubleNVPair)nvPair).getValue());
                return;
            }
            case ENUM: {
                AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)nvPair;
                stringSerializer.writeString(out, enumPair.getClassName());
                out.writeInt(enumPair.getOrdinal());
                return;
            }
            case FLOAT: {
                out.writeFloat(((AbstractNVPair.FloatNVPair)nvPair).getValue());
                return;
            }
            case INT: {
                out.writeInt(((AbstractNVPair.IntNVPair)nvPair).getValue());
                return;
            }
            case LONG: {
                out.writeLong(((AbstractNVPair.LongNVPair)nvPair).getValue());
                return;
            }
            case NULL: {
                return;
            }
            case SHORT: {
                out.writeShort(((AbstractNVPair.ShortNVPair)nvPair).getValue());
                return;
            }
            case SQL_DATE: {
                out.writeLong(((AbstractNVPair.SqlDateNVPair)nvPair).getValue().getTime());
                return;
            }
            case STRING: {
                String value = ((AbstractNVPair.StringNVPair)nvPair).getValue();
                try {
                    stringSerializer.writeStringBytes(out, value.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)e);
                }
                return;
            }
            case VALUE_ID: {
                out.writeLong(((AbstractNVPair.ValueIdNVPair)nvPair).getValue().toLong());
                return;
            }
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    public NVPair deserialize(TCByteBufferInput in, ObjectStringSerializer serializer) throws IOException {
        String name = serializer.readString(in);
        byte ordinal = in.readByte();
        ValueType type = ALL_TYPES[ordinal];
        switch (type) {
            case BOOLEAN: {
                return new AbstractNVPair.BooleanNVPair(name, in.readBoolean());
            }
            case BYTE: {
                return new AbstractNVPair.ByteNVPair(name, in.readByte());
            }
            case BYTE_ARRAY: {
                int len = in.readInt();
                byte[] data = new byte[len];
                in.read(data, 0, len);
                return new AbstractNVPair.ByteArrayNVPair(name, data);
            }
            case CHAR: {
                return new AbstractNVPair.CharNVPair(name, in.readChar());
            }
            case DATE: {
                return new AbstractNVPair.DateNVPair(name, new java.util.Date(in.readLong()));
            }
            case DOUBLE: {
                return new AbstractNVPair.DoubleNVPair(name, in.readDouble());
            }
            case ENUM: {
                String className = serializer.readString(in);
                int enumOrdinal = in.readInt();
                return new AbstractNVPair.EnumNVPair(name, className, enumOrdinal);
            }
            case FLOAT: {
                return new AbstractNVPair.FloatNVPair(name, in.readFloat());
            }
            case INT: {
                return new AbstractNVPair.IntNVPair(name, in.readInt());
            }
            case LONG: {
                return new AbstractNVPair.LongNVPair(name, in.readLong());
            }
            case NULL: {
                return new AbstractNVPair.NullNVPair(name);
            }
            case SHORT: {
                return new AbstractNVPair.ShortNVPair(name, in.readShort());
            }
            case SQL_DATE: {
                return new AbstractNVPair.SqlDateNVPair(name, new Date(in.readLong()));
            }
            case STRING: {
                return new AbstractNVPair.StringNVPair(name, new String(serializer.readStringBytes(in), "UTF-8"));
            }
            case VALUE_ID: {
                return new AbstractNVPair.ValueIdNVPair(name, new ValueID(in.readLong()));
            }
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    static {
        int length = ValueType.values().length;
        if (length > 127) {
            throw new AssertionError((Object)"Current implementation does not allow for more 127 types");
        }
    }
}

