/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.metadata;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.ObjectID;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.metadata.MetaDataDescriptor;
import com.tc.object.metadata.MetaDataDescriptorInternal;
import com.tc.object.metadata.NVPairSerializer;
import com.tc.util.ClassUtils;
import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import java.io.IOException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MetaDataDescriptorImpl
implements MetaDataDescriptorInternal {
    private static final NVPairSerializer NVPAIR_SERIALIZER = new NVPairSerializer();
    private static final MetaDataDescriptorImpl TEMPLATE = new MetaDataDescriptorImpl("template");
    public static final MetaDataDescriptor[] EMPTY_ARRAY = new MetaDataDescriptor[0];
    private final String category;
    private final List<NVPair> metaDatas;
    private ObjectID oid;
    private static final Map<Class, ValueType> TYPES;

    public MetaDataDescriptorImpl(String category) {
        this(category, new ArrayList<NVPair>(), ObjectID.NULL_ID);
    }

    private MetaDataDescriptorImpl(String category, List<NVPair> metaDatas, ObjectID oid) {
        this.category = category;
        this.metaDatas = metaDatas;
        this.oid = oid;
    }

    @Override
    public Iterator<NVPair> getMetaDatas() {
        return this.metaDatas.iterator();
    }

    @Override
    public int numberOfNvPairs() {
        return this.metaDatas.size();
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    @Override
    public ObjectID getObjectId() {
        return this.oid;
    }

    @Override
    public void setObjectID(ObjectID id) {
        this.oid = id;
    }

    public Object deserializeFrom(TCByteBufferInput in, ObjectStringSerializer serializer) throws IOException {
        String cat = serializer.readString(in);
        ObjectID id = new ObjectID(in.readLong());
        int size = in.readInt();
        ArrayList<NVPair> data = new ArrayList<NVPair>(size);
        for (int i = 0; i < size; ++i) {
            data.add(NVPAIR_SERIALIZER.deserialize(in, serializer));
        }
        return new MetaDataDescriptorImpl(cat, Collections.unmodifiableList(data), id);
    }

    @Override
    public void serializeTo(TCByteBufferOutput out, ObjectStringSerializer serializer) {
        serializer.writeString(out, this.category);
        if (this.oid.isNull()) {
            throw new AssertionError((Object)"OID never set");
        }
        out.writeLong(this.oid.toLong());
        out.writeInt(this.metaDatas.size());
        for (NVPair nvpair : this.metaDatas) {
            NVPAIR_SERIALIZER.serialize(nvpair, out, serializer);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.category + "): " + this.metaDatas.toString();
    }

    public static MetaDataDescriptorInternal deserializeInstance(TCByteBufferInputStream in, ObjectStringSerializer serializer) throws IOException {
        return (MetaDataDescriptorInternal)TEMPLATE.deserializeFrom(in, serializer);
    }

    @Override
    public void add(String name, boolean value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.BooleanNVPair(name, value));
    }

    @Override
    public void add(String name, byte value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.ByteNVPair(name, value));
    }

    @Override
    public void add(String name, char value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.CharNVPair(name, value));
    }

    @Override
    public void add(String name, double value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.DoubleNVPair(name, value));
    }

    @Override
    public void add(String name, float value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.FloatNVPair(name, value));
    }

    @Override
    public void add(String name, int value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.IntNVPair(name, value));
    }

    @Override
    public void add(String name, long value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.LongNVPair(name, value));
    }

    @Override
    public void add(String name, short value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.ShortNVPair(name, value));
    }

    @Override
    public void add(String name, String value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.StringNVPair(name, value));
    }

    @Override
    public void add(String name, byte[] value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.ByteArrayNVPair(name, value));
    }

    @Override
    public void add(String name, Enum value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.EnumNVPair(name, value));
    }

    @Override
    public void add(String name, java.util.Date value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.DateNVPair(name, value));
    }

    @Override
    public void add(String name, Date value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.SqlDateNVPair(name, value));
    }

    @Override
    public void add(String name, ObjectID value) {
        this.metaDatas.add((NVPair)new AbstractNVPair.ValueIdNVPair(name, new ValueID(value.toLong())));
    }

    @Override
    public void addNull(String name) {
        this.metaDatas.add((NVPair)new AbstractNVPair.NullNVPair(name));
    }

    @Override
    public void set(String name, Object value) {
        ListIterator<NVPair> iter = this.metaDatas.listIterator();
        while (iter.hasNext()) {
            NVPair nvPair = iter.next();
            if (!nvPair.getName().equals(name)) continue;
            iter.set(nvPair.cloneWithNewValue(value));
        }
    }

    @Override
    public void add(String name, Object value) {
        if (value == null) {
            this.addNull(name);
            return;
        }
        Class<?> type = value.getClass();
        ValueType vt = TYPES.get(type);
        if (vt != null) {
            switch (vt) {
                case BOOLEAN: {
                    this.add(name, (Boolean)value);
                    break;
                }
                case BYTE: {
                    this.add(name, (Byte)value);
                    break;
                }
                case CHAR: {
                    this.add(name, ((Character)value).charValue());
                    break;
                }
                case DOUBLE: {
                    this.add(name, (Double)value);
                    break;
                }
                case FLOAT: {
                    this.add(name, ((Float)value).floatValue());
                    break;
                }
                case INT: {
                    this.add(name, (Integer)value);
                    break;
                }
                case LONG: {
                    this.add(name, (Long)value);
                    break;
                }
                case SHORT: {
                    this.add(name, (Short)value);
                    break;
                }
                case DATE: {
                    this.add(name, (java.util.Date)value);
                    break;
                }
                case SQL_DATE: {
                    this.add(name, (Date)value);
                    break;
                }
                case BYTE_ARRAY: {
                    this.add(name, (byte[])value);
                    break;
                }
                case STRING: {
                    this.add(name, (String)value);
                    break;
                }
                case ENUM: {
                    throw new AssertionError();
                }
                case NULL: {
                    throw new AssertionError();
                }
                case VALUE_ID: {
                    this.add(name, (ObjectID)value);
                }
            }
            return;
        }
        if (ClassUtils.isDsoEnum(type)) {
            this.add(name, (Enum)value);
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    static {
        HashMap<Class, ValueType> map = new HashMap<Class, ValueType>();
        map.put(Byte.class, ValueType.BYTE);
        map.put(Boolean.class, ValueType.BOOLEAN);
        map.put(Character.class, ValueType.CHAR);
        map.put(Double.class, ValueType.DOUBLE);
        map.put(Float.class, ValueType.FLOAT);
        map.put(Integer.class, ValueType.INT);
        map.put(Short.class, ValueType.SHORT);
        map.put(Long.class, ValueType.LONG);
        map.put(String.class, ValueType.STRING);
        map.put(java.util.Date.class, ValueType.DATE);
        map.put(Date.class, ValueType.SQL_DATE);
        map.put(byte[].class, ValueType.BYTE_ARRAY);
        map.put(ObjectID.class, ValueType.VALUE_ID);
        TYPES = map;
    }
}

