/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.management;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.NodeID;
import com.tc.object.management.RemoteCallDescriptor;
import com.tc.object.management.SerializationHelper;
import com.tc.object.management.ServiceID;
import java.io.IOException;

public class RemoteCallHolder
extends RemoteCallDescriptor {
    private byte[] serializedArgs;

    public RemoteCallHolder() {
    }

    public RemoteCallHolder(RemoteCallDescriptor remoteCallDescriptor, Object[] args) {
        super(remoteCallDescriptor.getL1Node(), remoteCallDescriptor.getServiceID(), remoteCallDescriptor.getMethodName(), remoteCallDescriptor.getArgTypeNames());
        this.serializedArgs = SerializationHelper.serialize(args);
    }

    protected RemoteCallHolder(NodeID l1Node, ServiceID serviceID, String methodName, String[] argTypeNames, Object[] args) {
        super(l1Node, serviceID, methodName, argTypeNames);
        this.serializedArgs = SerializationHelper.serialize(args);
    }

    public Object[] getArgs(ClassLoader classLoader) throws ClassNotFoundException {
        return (Object[])SerializationHelper.deserialize(this.serializedArgs, classLoader);
    }

    public void setArgs(Object[] args) {
        this.serializedArgs = SerializationHelper.serialize(args);
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        super.serializeTo(serialOutput);
        if (this.serializedArgs == null) {
            serialOutput.writeInt(0);
        } else {
            serialOutput.writeInt(this.serializedArgs.length);
            serialOutput.write(this.serializedArgs);
        }
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        super.deserializeFrom(serialInput);
        int arraySize = serialInput.readInt();
        this.serializedArgs = new byte[arraySize];
        serialInput.readFully(this.serializedArgs);
        return this;
    }
}

