/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.management;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.NodeID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.object.management.ServiceID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class RemoteCallDescriptor
implements TCSerializable {
    private NodeID l1Node;
    private ServiceID serviceID;
    private String methodName;
    private String[] argTypeNames;

    public RemoteCallDescriptor() {
    }

    public RemoteCallDescriptor(NodeID l1Node, ServiceID serviceID, String methodName, String[] argTypeNames) {
        this.l1Node = l1Node;
        this.serviceID = serviceID;
        this.methodName = methodName;
        this.argTypeNames = argTypeNames;
    }

    public NodeID getL1Node() {
        return this.l1Node;
    }

    public ServiceID getServiceID() {
        return this.serviceID;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String[] getArgTypeNames() {
        return this.argTypeNames;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        new NodeIDSerializer(this.l1Node).serializeTo(serialOutput);
        this.serviceID.serializeTo(serialOutput);
        serialOutput.writeString(this.methodName);
        if (this.argTypeNames != null) {
            serialOutput.writeInt(this.argTypeNames.length);
            for (String argTypeName : this.argTypeNames) {
                serialOutput.writeString(argTypeName);
            }
        } else {
            serialOutput.writeInt(-1);
        }
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.l1Node = ((NodeIDSerializer)new NodeIDSerializer().deserializeFrom(serialInput)).getNodeID();
        this.serviceID = (ServiceID)new ServiceID().deserializeFrom(serialInput);
        this.methodName = serialInput.readString();
        int argTypeNamesCount = serialInput.readInt();
        if (argTypeNamesCount > -1) {
            ArrayList<String> argTypeNamesList = new ArrayList<String>(argTypeNamesCount);
            for (int i = 0; i < argTypeNamesCount; ++i) {
                argTypeNamesList.add(serialInput.readString());
            }
            this.argTypeNames = argTypeNamesList.toArray(new String[argTypeNamesCount]);
        } else {
            this.argTypeNames = null;
        }
        return this;
    }

    public String toString() {
        return "RemoteCallDescriptor of node " + this.l1Node + " serviceID " + this.serviceID + " method " + this.methodName + " with args " + Arrays.toString(this.argTypeNames);
    }
}

