/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.object.locks.ServerLockContext;
import com.tc.object.locks.ServerLockLevel;
import com.tc.util.Assert;

public class ServerLockContextStateMachine {
    public boolean canSetState(ServerLockContext.State oldState, ServerLockContext.State newState) {
        ServerLockContext.State expectedState = null;
        if (oldState == null) {
            return true;
        }
        switch (newState.getType()) {
            case GREEDY_HOLDER: {
                expectedState = this.moveToGreedy(oldState);
                break;
            }
            case HOLDER: {
                expectedState = this.moveToHolder(oldState);
                break;
            }
            case PENDING: {
                expectedState = this.moveToPending(oldState);
                break;
            }
            case WAITER: {
                expectedState = this.moveToWaiter(oldState);
                break;
            }
            case TRY_PENDING: {
                return true;
            }
        }
        return expectedState == newState;
    }

    private ServerLockContext.State moveToWaiter(ServerLockContext.State oldState) {
        Assert.assertNotNull((Object)oldState);
        Assert.assertTrue(oldState.getType() == ServerLockContext.Type.HOLDER);
        Assert.assertTrue(oldState.getLockLevel() == ServerLockLevel.WRITE);
        switch (oldState.getLockLevel()) {
            case WRITE: {
                return ServerLockContext.State.WAITER;
            }
        }
        throw new IllegalStateException("Should never come here");
    }

    private ServerLockContext.State moveToGreedy(ServerLockContext.State oldState) {
        Assert.assertNotNull((Object)oldState);
        Assert.assertTrue(oldState.getType() == ServerLockContext.Type.PENDING || oldState.getType() == ServerLockContext.Type.TRY_PENDING || oldState.getType() == ServerLockContext.Type.WAITER);
        switch (oldState.getLockLevel()) {
            case READ: {
                return ServerLockContext.State.GREEDY_HOLDER_READ;
            }
            case WRITE: {
                return ServerLockContext.State.GREEDY_HOLDER_WRITE;
            }
        }
        throw new IllegalStateException("Should never come here");
    }

    private ServerLockContext.State moveToHolder(ServerLockContext.State oldState) {
        Assert.assertNotNull((Object)oldState);
        Assert.assertTrue(oldState.getType() == ServerLockContext.Type.PENDING || oldState.getType() == ServerLockContext.Type.TRY_PENDING || oldState.getType() == ServerLockContext.Type.WAITER);
        switch (oldState.getLockLevel()) {
            case READ: {
                return ServerLockContext.State.HOLDER_READ;
            }
            case WRITE: {
                return ServerLockContext.State.HOLDER_WRITE;
            }
        }
        throw new IllegalStateException("Should never come here");
    }

    private ServerLockContext.State moveToPending(ServerLockContext.State oldState) {
        Assert.assertNotNull((Object)oldState);
        Assert.assertTrue(oldState.getType() == ServerLockContext.Type.WAITER);
        switch (oldState.getLockLevel()) {
            case READ: {
                return ServerLockContext.State.PENDING_READ;
            }
            case WRITE: {
                return ServerLockContext.State.PENDING_WRITE;
            }
        }
        throw new IllegalStateException("Should never come here");
    }
}

