/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.locks.ClientServerExchangeLockContext;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LockIDSerializer;
import com.tc.object.msg.LockRequestMessage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class RecallBatchContext
implements TCSerializable {
    private Collection<ClientServerExchangeLockContext> contexts;
    private LockID lockID;

    public RecallBatchContext() {
    }

    public RecallBatchContext(Collection<ClientServerExchangeLockContext> lockState, LockID lockID) {
        this.contexts = lockState;
        this.lockID = lockID;
    }

    public void addToMessage(LockRequestMessage lrm) {
        lrm.addRecallBatchContext(this);
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput in) throws IOException {
        LockIDSerializer ls = new LockIDSerializer();
        ls.deserializeFrom(in);
        this.lockID = ls.getLockID();
        int length = in.readInt();
        this.contexts = new ArrayList<ClientServerExchangeLockContext>();
        for (int i = 0; i < length; ++i) {
            this.contexts.add((ClientServerExchangeLockContext)new ClientServerExchangeLockContext().deserializeFrom(in));
        }
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput out) {
        LockIDSerializer ls = new LockIDSerializer(this.lockID);
        ls.serializeTo(out);
        out.writeInt(this.contexts.size());
        for (ClientServerExchangeLockContext lockContext : this.contexts) {
            lockContext.serializeTo(out);
        }
    }

    public Collection<ClientServerExchangeLockContext> getContexts() {
        return this.contexts;
    }

    public LockID getLockID() {
        return this.lockID;
    }
}

