/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.locks.LockID;
import java.io.IOException;

public class LongLockID
implements LockID {
    private static final long serialVersionUID = 2901968176144726989L;
    private long id;

    public LongLockID() {
        this(-1L);
    }

    public LongLockID(long id) {
        this.id = id;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.id + ")";
    }

    public String asString() {
        return Long.toString(this.id);
    }

    public int hashCode() {
        return (int)this.id ^ (int)(this.id >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LongLockID) {
            LongLockID lid = (LongLockID)obj;
            return this.id == lid.id;
        }
        return false;
    }

    public int compareTo(Object o) {
        if (o instanceof LongLockID) {
            LongLockID other = (LongLockID)o;
            if (this.id < other.id) {
                return -1;
            }
            if (this.id > other.id) {
                return 1;
            }
            return 0;
        }
        if (o instanceof LockID) {
            if (((LockID)o).getLockType() == LockID.LockIDType.DSO_LITERAL) {
                throw new ClassCastException("Can't compare LiteralLockID types.");
            }
            return this.toString().compareTo(o.toString());
        }
        throw new ClassCastException(o + " is not an instance of LockID");
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.id = serialInput.readLong();
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.id);
    }

    @Override
    public LockID.LockIDType getLockType() {
        return LockID.LockIDType.LONG;
    }
}

