/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.locks.DsoLiteralLockID;
import com.tc.object.locks.DsoLockID;
import com.tc.object.locks.DsoVolatileLockID;
import com.tc.object.locks.LockID;
import com.tc.object.locks.LongLockID;
import com.tc.object.locks.StringLockID;
import java.io.IOException;

public class LockIDSerializer
implements TCSerializable {
    private LockID lockID;

    public LockIDSerializer() {
    }

    public LockIDSerializer(LockID lockID) {
        this.lockID = lockID;
    }

    public LockID getLockID() {
        return this.lockID;
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        byte type = serialInput.readByte();
        this.lockID = this.getImpl(type);
        this.lockID.deserializeFrom(serialInput);
        return this;
    }

    private LockID getImpl(byte type) {
        try {
            switch (LockID.LockIDType.values()[type]) {
                case LONG: {
                    return new LongLockID();
                }
                case STRING: {
                    return new StringLockID();
                }
                case DSO: {
                    return new DsoLockID();
                }
                case DSO_LITERAL: {
                    return new DsoLiteralLockID();
                }
                case DSO_VOLATILE: {
                    return new DsoVolatileLockID();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        throw new AssertionError((Object)("Unknown type : " + type));
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeByte((byte)this.lockID.getLockType().ordinal());
        this.lockID.serializeTo(serialOutput);
    }
}

