/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.ObjectID;
import com.tc.object.locks.LockID;
import java.io.IOException;

public class DsoVolatileLockID
implements LockID {
    private static final long serialVersionUID = -4166488899470211826L;
    private long objectId;
    private String fieldName;

    public DsoVolatileLockID() {
    }

    public DsoVolatileLockID(ObjectID oid, String fieldName) {
        this.objectId = oid.toLong();
        this.fieldName = fieldName;
    }

    @Deprecated
    public String asString() {
        return null;
    }

    @Override
    public LockID.LockIDType getLockType() {
        return LockID.LockIDType.DSO_VOLATILE;
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.objectId = serialInput.readLong();
        this.fieldName = serialInput.readString();
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.objectId);
        serialOutput.writeString(this.fieldName);
    }

    public ObjectID getObjectID() {
        return new ObjectID(this.objectId);
    }

    public int hashCode() {
        return 5 * ((int)this.objectId ^ (int)(this.objectId >>> 32)) ^ 7 * this.fieldName.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DsoVolatileLockID) {
            return this.objectId == ((DsoVolatileLockID)o).objectId && this.fieldName.equals(((DsoVolatileLockID)o).fieldName);
        }
        return false;
    }

    public String toString() {
        return "DsoVolatileLockID(" + new ObjectID(this.objectId) + "." + this.fieldName + ")";
    }

    public int compareTo(Object o) {
        if (o instanceof DsoVolatileLockID) {
            DsoVolatileLockID other = (DsoVolatileLockID)o;
            if (this.objectId == other.objectId && this.fieldName.equals(other.fieldName)) {
                return 0;
            }
            return (this.objectId + "." + this.fieldName).compareTo(other.objectId + "." + other.fieldName);
        }
        if (o instanceof LockID) {
            if (((LockID)o).getLockType() == LockID.LockIDType.DSO_LITERAL) {
                throw new ClassCastException("Can't compare LiteralLockID types.");
            }
            return this.toString().compareTo(o.toString());
        }
        throw new ClassCastException(o + " is not an instance of LockID");
    }
}

