/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.ObjectID;
import com.tc.object.locks.LockID;
import java.io.IOException;

public class DsoLockID
implements LockID {
    private static final long serialVersionUID = 81985529216486895L;
    private long objectId;

    public DsoLockID() {
    }

    public DsoLockID(ObjectID objectId) {
        this.objectId = objectId.toLong();
    }

    public String asString() {
        return null;
    }

    @Override
    public LockID.LockIDType getLockType() {
        return LockID.LockIDType.DSO;
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.objectId = serialInput.readLong();
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeLong(this.objectId);
    }

    public int hashCode() {
        return (int)this.objectId ^ (int)(this.objectId >>> 32);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DsoLockID) {
            return this.objectId == ((DsoLockID)o).objectId;
        }
        return false;
    }

    public String toString() {
        return "DsoLockID(" + new ObjectID(this.objectId) + ")";
    }

    public ObjectID getObjectID() {
        return new ObjectID(this.objectId);
    }

    public int compareTo(Object o) {
        if (o instanceof DsoLockID) {
            DsoLockID other = (DsoLockID)o;
            if (this.objectId < other.objectId) {
                return -1;
            }
            if (this.objectId > other.objectId) {
                return 1;
            }
            return 0;
        }
        if (o instanceof LockID) {
            if (((LockID)o).getLockType() == LockID.LockIDType.DSO_LITERAL) {
                throw new ClassCastException("Can't compare LiteralLockID types.");
            }
            return this.toString().compareTo(o.toString());
        }
        throw new ClassCastException(o + " is not an instance of LockID");
    }
}

