/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.locks;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.object.LiteralValues;
import com.tc.object.dna.impl.ClassInstance;
import com.tc.object.dna.impl.EnumInstance;
import com.tc.object.dna.impl.UTF8ByteDataHolder;
import com.tc.object.locks.LockID;
import java.io.IOException;

public class DsoLiteralLockID
implements LockID {
    private static final long serialVersionUID = 1671563333186673827L;
    private Object literal;

    public DsoLiteralLockID() {
    }

    public DsoLiteralLockID(Object literal) throws IllegalArgumentException {
        this.literal = DsoLiteralLockID.translateLiteral(literal);
    }

    public String asString() {
        return null;
    }

    @Override
    public LockID.LockIDType getLockType() {
        return LockID.LockIDType.DSO_LITERAL;
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        LiteralValues type = LiteralValues.values()[serialInput.readByte()];
        switch (type) {
            case INTEGER: {
                this.literal = serialInput.readInt();
                return this;
            }
            case LONG: {
                this.literal = serialInput.readLong();
                return this;
            }
            case CHARACTER: {
                this.literal = Character.valueOf(serialInput.readChar());
                return this;
            }
            case FLOAT: {
                this.literal = Float.valueOf(serialInput.readFloat());
                return this;
            }
            case DOUBLE: {
                this.literal = serialInput.readDouble();
                return this;
            }
            case BYTE: {
                this.literal = serialInput.readByte();
                return this;
            }
            case BOOLEAN: {
                this.literal = serialInput.readBoolean();
                return this;
            }
            case SHORT: {
                this.literal = serialInput.readShort();
                return this;
            }
            case STRING: {
                throw new AssertionError((Object)"String literal types should be handled by StringLockID");
            }
            case ENUM_HOLDER: {
                String className = serialInput.readString();
                ClassInstance classInstance = new ClassInstance(new UTF8ByteDataHolder(className));
                String enumName = serialInput.readString();
                this.literal = new EnumInstance(classInstance, new UTF8ByteDataHolder(enumName));
                return this;
            }
            case STRING_BYTES: 
            case JAVA_LANG_CLASS_HOLDER: 
            case STRING_BYTES_COMPRESSED: {
                throw new AssertionError((Object)("Unusual type found in serialized DsoLiteralLockID stream " + type));
            }
            case OBJECT: 
            case OBJECT_ID: 
            case JAVA_LANG_CLASS: 
            case ARRAY: 
            case ENUM: {
                throw new AssertionError((Object)("Illegal type found in serialized DsoLiteralLockID stream " + type));
            }
        }
        throw new AssertionError((Object)("Null type found in serialized DsoLiteralLockID stream " + type));
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        LiteralValues type = LiteralValues.valueFor(this.literal);
        serialOutput.writeByte(type.ordinal());
        switch (type) {
            case INTEGER: {
                serialOutput.writeInt((Integer)this.literal);
                break;
            }
            case LONG: {
                serialOutput.writeLong((Long)this.literal);
                break;
            }
            case CHARACTER: {
                serialOutput.writeChar(((Character)this.literal).charValue());
                break;
            }
            case FLOAT: {
                serialOutput.writeFloat(((Float)this.literal).floatValue());
                break;
            }
            case DOUBLE: {
                serialOutput.writeDouble((Double)this.literal);
                break;
            }
            case BYTE: {
                serialOutput.writeByte(((Byte)this.literal).byteValue());
                break;
            }
            case BOOLEAN: {
                serialOutput.writeBoolean((Boolean)this.literal);
                break;
            }
            case SHORT: {
                serialOutput.writeShort(((Short)this.literal).shortValue());
                break;
            }
            case STRING: {
                throw new AssertionError((Object)"String literal types should be handled by StringLockID");
            }
            case ENUM_HOLDER: {
                EnumInstance enumInstance = (EnumInstance)this.literal;
                serialOutput.writeString(enumInstance.getClassInstance().getName().asString());
                serialOutput.writeString(enumInstance.getEnumName().asString());
                break;
            }
            case STRING_BYTES: 
            case JAVA_LANG_CLASS_HOLDER: 
            case STRING_BYTES_COMPRESSED: {
                throw new AssertionError((Object)("Unusual type passed to DsoLiteralLockID constructor " + type));
            }
            case OBJECT: 
            case OBJECT_ID: 
            case JAVA_LANG_CLASS: 
            case ARRAY: 
            case ENUM: {
                throw new AssertionError((Object)("Illegal type passed to DsoLiteralLockID constructor " + type));
            }
        }
    }

    public int hashCode() {
        return LiteralValues.calculateDsoHashCode(this.literal);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DsoLiteralLockID) {
            return this.literal.equals(((DsoLiteralLockID)o).literal);
        }
        return false;
    }

    public int compareTo(Object o) {
        throw new ClassCastException("DsoLiteralLockID instances can't be compared");
    }

    private static Object translateLiteral(Object literal) throws IllegalArgumentException {
        LiteralValues type = LiteralValues.valueFor(literal);
        switch (type) {
            case ENUM: {
                Class<?> clazz = literal.getClass();
                ClassInstance classInstance = new ClassInstance(new UTF8ByteDataHolder(clazz.getName()));
                return new EnumInstance(classInstance, new UTF8ByteDataHolder(((Enum)literal).name()));
            }
        }
        return literal;
    }
}

