/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCDataInput;
import com.tc.io.TCDataOutput;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ObjectStringSerializerImpl
implements ObjectStringSerializer {
    private final double STRING_LEN_TO_UTF8_RATIO = 1.25;
    private final Map<Object, Integer> stringToID = new HashMap<Object, Integer>();
    private final Map<Integer, Object> idToString = new HashMap<Integer, Object>();
    private final Map<Object, Integer> bytesToID = new HashMap<Object, Integer>();
    private final Map<Integer, Object> idToBytes = new HashMap<Integer, Object>();
    private int approximateBytesWritten = 0;

    @Override
    public synchronized void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeInt(this.stringToID.size());
        Serialize serializeProcedure = new Serialize(serialOutput);
        for (Map.Entry<Object, Integer> entry : this.stringToID.entrySet()) {
            serializeProcedure.writeToTcDataOutput(entry.getKey(), entry.getValue());
        }
        serialOutput.writeInt(this.bytesToID.size());
        BytesSerialize bytesSerializeProcedure = new BytesSerialize(serialOutput);
        for (Map.Entry<Object, Integer> entry : this.bytesToID.entrySet()) {
            bytesSerializeProcedure.write(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        int size = serialInput.readInt();
        for (int i = 0; i < size; ++i) {
            this.addStringAndID(serialInput.readString(), serialInput.readInt());
        }
        int encodingSize = serialInput.readInt();
        for (int i = 0; i < encodingSize; ++i) {
            int len = serialInput.readInt();
            byte[] b = new byte[len];
            serialInput.readFully(b);
            this.addBytesAndID(b, serialInput.readInt());
        }
        return this;
    }

    @Override
    public synchronized void writeString(TCDataOutput out, String string) {
        int sid = -1;
        sid = this.stringToID.containsKey(string) ? this.idForString(string) : this.createID(string);
        out.writeInt(sid);
    }

    @Override
    public synchronized void writeStringBytes(TCDataOutput out, byte[] bytes) {
        BytesKey key = new BytesKey(bytes);
        int id = this.bytesToID.containsKey(key) ? this.bytesToID.get(key).intValue() : this.createBytesID(key);
        out.writeInt(id);
    }

    @Override
    public synchronized void writeFieldName(TCDataOutput out, String fieldName) {
        this.writeString(out, fieldName);
    }

    @Override
    public synchronized String readString(TCDataInput in) throws IOException {
        int id = in.readInt();
        String string = this.stringForID(id);
        if (string == null) {
            throw new AssertionError((Object)("cid:" + id + " map:" + this.stringToID));
        }
        return string;
    }

    @Override
    public synchronized byte[] readStringBytes(TCDataInput input) throws IOException {
        int id = input.readInt();
        byte[] bytes = (byte[])this.idToBytes.get(id);
        if (bytes == null) {
            throw new AssertionError((Object)("missing bytes for id=" + id));
        }
        return bytes;
    }

    @Override
    public synchronized String readFieldName(TCDataInput in) throws IOException {
        int stringID = in.readInt();
        String fieldName = this.stringForID(stringID);
        Assert.eval(fieldName != null);
        return fieldName;
    }

    private void addStringAndID(String name, int id) {
        name = name.intern();
        this.stringToID.put(name, id);
        this.idToString.put(id, name);
    }

    private void addBytesAndID(byte[] b, int id) {
        this.bytesToID.put(new BytesKey(b), id);
        this.idToBytes.put(id, b);
    }

    private String stringForID(int id) {
        return (String)this.idToString.get(id);
    }

    private int idForString(String string) {
        return this.stringToID.get(string);
    }

    private int createID(String string) {
        Assert.assertNotNull(string);
        int newID = this.stringToID.size() + 1;
        this.stringToID.put(string, newID);
        this.idToString.put(newID, string);
        this.approximateBytesWritten += 2;
        this.approximateBytesWritten = (int)((double)this.approximateBytesWritten + (double)string.length() * 1.25);
        this.approximateBytesWritten += 2;
        this.approximateBytesWritten += 4;
        return newID;
    }

    private int createBytesID(BytesKey key) {
        int id = this.bytesToID.size() + 1;
        this.bytesToID.put(key, id);
        this.idToBytes.put(id, key.getBytes());
        this.approximateBytesWritten += key.getBytes().length;
        this.approximateBytesWritten += 8;
        return id;
    }

    @Override
    public int getApproximateBytesWritten() {
        return this.approximateBytesWritten;
    }

    private static class BytesKey {
        private final byte[] b;

        BytesKey(byte[] b) {
            this.b = b;
        }

        public int hashCode() {
            return Arrays.hashCode(this.b);
        }

        public boolean equals(Object obj) {
            if (obj instanceof BytesKey) {
                BytesKey other = (BytesKey)obj;
                return Arrays.equals(this.b, other.b);
            }
            return false;
        }

        byte[] getBytes() {
            return this.b;
        }
    }

    private static class BytesSerialize {
        private final TCDataOutput out;

        public BytesSerialize(TCDataOutput out) {
            this.out = out;
        }

        public boolean write(Object key, int value) {
            BytesKey bk = (BytesKey)key;
            byte[] b = bk.getBytes();
            this.out.writeInt(b.length);
            this.out.write(b);
            this.out.writeInt(value);
            return true;
        }
    }

    private static class Serialize {
        private final TCDataOutput out;

        public Serialize(TCDataOutput out) {
            this.out = out;
        }

        public boolean writeToTcDataOutput(Object key, int value) {
            this.out.writeString((String)key);
            this.out.writeInt(value);
            return true;
        }
    }
}

