/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.object.LogicalOperation;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.DNAWriter;
import com.tc.object.dna.api.DNAWriterInternal;
import com.tc.object.dna.api.LogicalChangeID;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.metadata.MetaDataDescriptorInternal;
import com.tc.util.Assert;
import com.tc.util.Conversion;
import java.nio.channels.IllegalSelectorException;
import java.util.ArrayList;
import java.util.List;

public class DNAWriterImpl
implements DNAWriterInternal {
    private static final int UNINITIALIZED = -1;
    private final TCByteBufferOutputStream output;
    private final TCByteBufferOutputStream.Mark headerMark;
    private final ObjectStringSerializer serializer;
    private final DNAEncodingInternal encoding;
    private final List<Appender> appenders = new ArrayList<Appender>(5);
    private byte flags = 0;
    private int metaDataLength = -1;
    private int firstLength = -1;
    private int totalLength = -1;
    private int lastStreamPos = -1;
    private int actionCount = 0;
    private boolean contiguous = true;
    private boolean hasMetaData = false;
    private int metaDataOffset = -1;

    public DNAWriterImpl(TCByteBufferOutputStream output, ObjectID id, String className, ObjectStringSerializer serializer, DNAEncodingInternal encoding, boolean isDelta) {
        this(output, id, className, serializer, encoding, -1L, isDelta);
    }

    protected DNAWriterImpl(TCByteBufferOutputStream output, ObjectID id, String className, ObjectStringSerializer serializer, DNAEncodingInternal encoding, long version, boolean isDelta) {
        this.output = output;
        this.encoding = encoding;
        this.serializer = serializer;
        this.headerMark = output.mark();
        output.writeInt(-1);
        output.writeInt(-1);
        output.writeInt(-1);
        output.writeByte(this.flags);
        output.writeLong(id.toLong());
        if (!isDelta) {
            serializer.writeString(output, className);
        }
        this.flags = Conversion.setFlag(this.flags, 4, isDelta);
        if (version != -1L) {
            this.flags = Conversion.setFlag(this.flags, 8, true);
            output.writeLong(version);
        }
    }

    @Override
    public void setIgnoreMissing(boolean ignoreMissing) {
        this.flags = Conversion.setFlag(this.flags, 16, ignoreMissing);
    }

    @Override
    public DNAWriter createAppender() {
        if (this.contiguous) {
            this.contiguous = !this.hasMetaData && this.output.getBytesWritten() == this.lastStreamPos;
        }
        Appender appender = new Appender(this, this.output);
        this.appenders.add(appender);
        return appender;
    }

    @Override
    public boolean isContiguous() {
        return this.contiguous;
    }

    @Override
    public void markSectionEnd() {
        if (this.lastStreamPos != -1) {
            throw new IllegalStateException("lastStreamPos=" + this.lastStreamPos);
        }
        if (this.totalLength != -1) {
            throw new IllegalStateException("totalLength=" + this.totalLength);
        }
        this.lastStreamPos = this.output.getBytesWritten();
        this.firstLength = this.totalLength = this.output.getBytesWritten() - this.headerMark.getPosition();
    }

    private void appenderSectionEnd(int appenderLength) {
        if (this.contiguous) {
            this.lastStreamPos = this.output.getBytesWritten();
        }
        this.totalLength += appenderLength;
    }

    @Override
    public void addLogicalAction(LogicalOperation method, Object[] parameters, LogicalChangeID logicalChangeID) {
        ++this.actionCount;
        this.output.writeByte(1);
        this.output.writeBoolean(logicalChangeID.isNull());
        if (!logicalChangeID.isNull()) {
            this.output.writeLong(logicalChangeID.toLong());
        }
        this.output.writeInt(method.ordinal());
        this.output.writeByte(parameters.length);
        for (Object parameter : parameters) {
            this.encoding.encode(parameter, this.output, this.serializer);
        }
    }

    @Override
    public void addSubArrayAction(int start, Object array, int length) {
        ++this.actionCount;
        this.output.writeByte(7);
        this.output.writeInt(start);
        this.encoding.encodeArray(array, this.output, length);
    }

    @Override
    public void addPhysicalAction(String fieldName, Object value) {
        this.addPhysicalAction(fieldName, value, value instanceof ObjectID);
    }

    @Override
    public void addPhysicalAction(String fieldName, Object value, boolean canBeReferenced) {
        if (value == null) {
            value = ObjectID.NULL_ID;
            canBeReferenced = true;
        }
        ++this.actionCount;
        if (canBeReferenced) {
            this.output.writeByte(6);
        } else {
            this.output.writeByte(2);
        }
        this.serializer.writeFieldName(this.output, fieldName);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void addArrayElementAction(int index, Object value) {
        ++this.actionCount;
        this.output.writeByte(3);
        this.output.writeInt(index);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void addEntireArray(Object value) {
        ++this.actionCount;
        this.output.writeByte(4);
        this.encoding.encodeArray(value, this.output);
    }

    @Override
    public void addLiteralValue(Object value) {
        ++this.actionCount;
        this.output.writeByte(5);
        this.encoding.encode(value, this.output);
    }

    @Override
    public void addMetaData(MetaDataDescriptorInternal md) {
        this.addMetaData(md, false);
    }

    protected void addMetaData(MetaDataDescriptorInternal md, boolean fromAppender) {
        if (!this.hasMetaData) {
            this.hasMetaData = true;
            if (!fromAppender) {
                this.metaDataOffset = this.output.getBytesWritten() - this.headerMark.getPosition();
            }
        }
        TCByteBufferOutputStream.Mark lengthMark = this.output.mark();
        this.output.writeInt(-1);
        md.serializeTo(this.output, this.serializer);
        int length = this.output.getBytesWritten() - lengthMark.getPosition();
        lengthMark.write(Conversion.int2Bytes(length));
        if (!fromAppender) {
            this.metaDataLength = this.metaDataLength == -1 ? length : (this.metaDataLength += length);
        }
    }

    @Override
    public void finalizeHeader() {
        if (Conversion.getFlag(this.flags, 4) && this.actionCount == 0) {
            throw new AssertionError((Object)"sending delta DNA with no actions!");
        }
        byte[] lengths = new byte[13];
        Conversion.writeInt(this.totalLength, lengths, 0);
        Conversion.writeInt(this.actionCount, lengths, 4);
        int totalMetaDataLength = 0;
        if (this.hasMetaData && this.metaDataLength != -1) {
            totalMetaDataLength = this.metaDataLength;
        }
        for (Appender a : this.appenders) {
            if (a.metaDataOffset == -1) continue;
            totalMetaDataLength += a.appendSectionLength - a.metaDataOffset;
        }
        if (totalMetaDataLength != 0) {
            Conversion.writeInt(this.totalLength - totalMetaDataLength, lengths, 8);
        }
        lengths[12] = this.flags;
        this.headerMark.write(lengths);
    }

    @Override
    public void setParentObjectID(ObjectID id) {
        this.checkVariableHeaderEmpty();
        this.flags = Conversion.setFlag(this.flags, 2, true);
        this.output.writeLong(id.toLong());
    }

    @Override
    public void setArrayLength(int length) {
        this.checkVariableHeaderEmpty();
        this.flags = Conversion.setFlag(this.flags, 1, true);
        this.output.writeInt(length);
    }

    private void checkVariableHeaderEmpty() {
        Assert.assertEquals(0, this.actionCount);
        Assert.assertFalse(Conversion.getFlag(this.flags, 2));
        Assert.assertFalse(Conversion.getFlag(this.flags, 1));
    }

    @Override
    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public void copyTo(TCByteBufferOutput dest) {
        if (this.hasMetaData) {
            this.headerMark.copyTo(dest, 0, this.metaDataOffset == -1 ? this.firstLength : this.metaDataOffset);
            for (Appender appender : this.appenders) {
                appender.copyActionsTo(dest);
            }
            if (this.metaDataLength != -1) {
                this.headerMark.copyTo(dest, this.metaDataOffset, this.metaDataLength);
            }
            for (Appender appender : this.appenders) {
                appender.copyMetaDataTo(dest);
            }
        } else {
            this.headerMark.copyTo(dest, this.firstLength);
            for (Appender appender : this.appenders) {
                appender.copyTo(dest);
            }
        }
    }

    @Override
    public void addLogicalAction(LogicalOperation method, Object[] parameters) {
        this.addLogicalAction(method, parameters, LogicalChangeID.NULL_ID);
    }

    private static class Appender
    implements DNAWriterInternal {
        private final DNAWriterImpl parent;
        private final TCByteBufferOutputStream output;
        private final TCByteBufferOutputStream.Mark startMark;
        private int appendSectionLength = -1;
        private int metaDataOffset = -1;

        Appender(DNAWriterImpl parent, TCByteBufferOutputStream output) {
            this.parent = parent;
            this.output = output;
            this.startMark = output.mark();
        }

        @Override
        public void setIgnoreMissing(boolean ignoreMissing) {
            this.parent.setIgnoreMissing(ignoreMissing);
        }

        void copyMetaDataTo(TCByteBufferOutput dest) {
            if (this.metaDataOffset != -1) {
                this.startMark.copyTo(dest, this.metaDataOffset, this.metaDataLength());
            }
        }

        void copyActionsTo(TCByteBufferOutput dest) {
            int length = this.appendSectionLength - this.metaDataLength();
            this.startMark.copyTo(dest, 0, length);
        }

        private int metaDataLength() {
            if (this.appendSectionLength == -1) {
                throw new IllegalSelectorException();
            }
            if (this.metaDataOffset == -1) {
                return 0;
            }
            return this.appendSectionLength - this.metaDataOffset;
        }

        @Override
        public void addArrayElementAction(int index, Object value) {
            this.parent.addArrayElementAction(index, value);
        }

        @Override
        public void addEntireArray(Object value) {
            this.parent.addEntireArray(value);
        }

        @Override
        public void addLiteralValue(Object value) {
            this.parent.addLiteralValue(value);
        }

        @Override
        public void addLogicalAction(LogicalOperation method, Object[] parameters, LogicalChangeID logicalChangeID) {
            this.parent.addLogicalAction(method, parameters, logicalChangeID);
        }

        @Override
        public void addLogicalAction(LogicalOperation method, Object[] parameters) {
            this.parent.addLogicalAction(method, parameters);
        }

        @Override
        public void addPhysicalAction(String fieldName, Object value, boolean canBeReferenced) {
            this.parent.addPhysicalAction(fieldName, value, canBeReferenced);
        }

        @Override
        public void addPhysicalAction(String fieldName, Object value) {
            this.parent.addPhysicalAction(fieldName, value);
        }

        @Override
        public void addSubArrayAction(int start, Object array, int length) {
            this.parent.addSubArrayAction(start, array, length);
        }

        @Override
        public void addMetaData(MetaDataDescriptorInternal md) {
            if (this.metaDataOffset == -1) {
                this.metaDataOffset = this.output.getBytesWritten() - this.startMark.getPosition();
            }
            this.parent.addMetaData(md, true);
        }

        @Override
        public int getActionCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setArrayLength(int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setParentObjectID(ObjectID id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public DNAWriter createAppender() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isContiguous() {
            return this.parent.isContiguous();
        }

        @Override
        public void markSectionEnd() {
            this.appendSectionLength = this.output.getBytesWritten() - this.startMark.getPosition();
            this.parent.appenderSectionEnd(this.appendSectionLength);
        }

        @Override
        public void copyTo(TCByteBufferOutput dest) {
            this.startMark.copyTo(dest, this.appendSectionLength);
        }

        @Override
        public void finalizeHeader() {
            throw new UnsupportedOperationException();
        }
    }
}

