/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.dna.impl;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.object.LogicalOperation;
import com.tc.object.ObjectID;
import com.tc.object.dna.api.DNACursor;
import com.tc.object.dna.api.DNAEncoding;
import com.tc.object.dna.api.DNAEncodingInternal;
import com.tc.object.dna.api.DNAException;
import com.tc.object.dna.api.DNAInternal;
import com.tc.object.dna.api.LiteralAction;
import com.tc.object.dna.api.LogicalAction;
import com.tc.object.dna.api.LogicalChangeID;
import com.tc.object.dna.api.MetaDataReader;
import com.tc.object.dna.api.PhysicalAction;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.StorageDNAEncodingImpl;
import com.tc.object.metadata.MetaDataDescriptorImpl;
import com.tc.object.metadata.MetaDataDescriptorInternal;
import com.tc.util.Assert;
import com.tc.util.Conversion;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;

public class DNAImpl
implements DNAInternal,
DNACursor,
TCSerializable {
    private static final DNAEncodingInternal DNA_STORAGE_ENCODING = new StorageDNAEncodingImpl();
    public static final MetaDataReader NULL_META_DATA_READER = new NullMetaDataReader();
    private final ObjectStringSerializer serializer;
    private final boolean createOutput;
    protected TCByteBufferInput input;
    protected TCByteBuffer[] dataOut;
    private int actionCount = 0;
    private int origActionCount;
    private boolean isDelta;
    private ObjectID id;
    private ObjectID parentID;
    private String typeName;
    private int arrayLength;
    private long version;
    private int dnaLength;
    private int metaDataOffset;
    private Object currentAction;
    private boolean wasDeserialized = false;
    private MetaDataReader metaDataReader = NULL_META_DATA_READER;

    public DNAImpl(ObjectStringSerializer serializer, boolean createOutput) {
        this.serializer = serializer;
        this.createOutput = createOutput;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeClassName(String className) {
        if (this.typeName == null) {
            this.typeName = className;
        }
    }

    @Override
    public ObjectID getObjectID() throws DNAException {
        return this.id;
    }

    @Override
    public ObjectID getParentObjectID() throws DNAException {
        return this.parentID;
    }

    @Override
    public DNACursor getCursor() {
        return this;
    }

    @Override
    public MetaDataReader getMetaDataReader() {
        return this.metaDataReader;
    }

    @Override
    public boolean hasMetaData() {
        return this.metaDataOffset > 0;
    }

    @Override
    public boolean next() throws IOException {
        try {
            return this.next(DNA_STORAGE_ENCODING);
        }
        catch (ClassNotFoundException e) {
            throw Assert.failure("Internal error");
        }
    }

    @Override
    public boolean next(DNAEncoding encoding) throws IOException, ClassNotFoundException {
        boolean hasNext;
        DNAEncodingInternal encodingInternal = (DNAEncodingInternal)encoding;
        boolean bl = hasNext = this.actionCount > 0;
        if (hasNext) {
            this.parseNext(encodingInternal);
            --this.actionCount;
        } else {
            int expect = 0;
            if (this.metaDataOffset > 0) {
                expect = this.dnaLength - this.metaDataOffset;
            }
            if (this.input.available() != expect) {
                throw new IOException(this.input.available() + " bytes remaining (expect " + expect + ")");
            }
        }
        return hasNext;
    }

    private void parseNext(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        byte recordType = this.input.readByte();
        switch (recordType) {
            case 2: {
                this.parsePhysical(encoding, false);
                return;
            }
            case 6: {
                this.parsePhysical(encoding, true);
                return;
            }
            case 1: {
                this.parseLogical(encoding);
                return;
            }
            case 3: {
                this.parseArrayElement(encoding);
                return;
            }
            case 4: {
                this.parseEntireArray(encoding);
                return;
            }
            case 5: {
                this.parseLiteralValue(encoding);
                return;
            }
            case 7: {
                this.parseSubArray(encoding);
                return;
            }
        }
        throw new IOException("Invalid record type: " + recordType);
    }

    private void parseSubArray(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        int startPos = this.input.readInt();
        Object subArray = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(subArray, startPos);
    }

    private void parseEntireArray(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        Object array = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(array);
    }

    private void parseLiteralValue(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        Object value = encoding.decode(this.input);
        this.currentAction = new LiteralAction(value);
    }

    private void parseArrayElement(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        int index = this.input.readInt();
        Object value = encoding.decode(this.input);
        this.currentAction = new PhysicalAction(index, value, value instanceof ObjectID);
    }

    private void parsePhysical(DNAEncodingInternal encoding, boolean isReference) throws IOException, ClassNotFoundException {
        Object value;
        String fieldName = this.serializer.readFieldName(this.input);
        this.currentAction = new PhysicalAction(fieldName, value, (value = encoding.decode(this.input)) instanceof ObjectID || isReference);
    }

    private void parseLogical(DNAEncodingInternal encoding) throws IOException, ClassNotFoundException {
        LogicalChangeID logicalChangeID = LogicalChangeID.NULL_ID;
        if (!this.input.readBoolean()) {
            logicalChangeID = new LogicalChangeID(this.input.readLong());
        }
        LogicalOperation method = LogicalOperation.values()[this.input.readInt()];
        int paramCount = this.input.read();
        if (paramCount < 0) {
            throw new AssertionError((Object)("Invalid param count:" + paramCount));
        }
        Object[] params = new Object[paramCount];
        for (int i = 0; i < params.length; ++i) {
            params[i] = encoding.decode(this.input, this.serializer);
        }
        this.currentAction = new LogicalAction(method, params, logicalChangeID);
    }

    @Override
    public LogicalAction getLogicalAction() {
        return (LogicalAction)this.currentAction;
    }

    @Override
    public PhysicalAction getPhysicalAction() {
        return (PhysicalAction)this.currentAction;
    }

    @Override
    public Object getAction() {
        return this.currentAction;
    }

    public String toString() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("DNAImpl\n");
            buf.append("{\n");
            buf.append("  type->" + this.getTypeName() + "\n");
            buf.append("  id->" + this.getObjectID() + "\n");
            buf.append("  version->" + this.getVersion() + "\n");
            buf.append("  isDelta->" + this.isDelta() + "\n");
            buf.append("  actionCount->" + this.actionCount + "\n");
            buf.append("  actionCount (orig)->" + this.origActionCount + "\n");
            buf.append("  deserialized?->" + this.wasDeserialized + "\n");
            buf.append("}\n");
            return buf.toString();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public int getArraySize() {
        return this.arrayLength;
    }

    @Override
    public boolean hasLength() {
        return this.getArraySize() >= 0;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public synchronized void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.write(this.dataOut);
    }

    @Override
    public Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.wasDeserialized = true;
        TCByteBufferInput.Mark mark = serialInput.mark();
        this.dnaLength = serialInput.readInt();
        if (this.dnaLength <= 0) {
            throw new IOException("Invalid length:" + this.dnaLength);
        }
        serialInput.tcReset(mark);
        this.input = serialInput.duplicateAndLimit(this.dnaLength);
        serialInput.skip(this.dnaLength);
        if (this.createOutput) {
            this.dataOut = this.input.toArray();
        }
        this.input.readInt();
        this.origActionCount = this.actionCount = this.input.readInt();
        if (this.actionCount < 0) {
            throw new IOException("Invalid action count:" + this.actionCount);
        }
        this.metaDataOffset = this.input.readInt();
        byte flags = this.input.readByte();
        this.id = new ObjectID(this.input.readLong());
        this.isDelta = Conversion.getFlag(flags, 4);
        if (!this.isDelta) {
            this.typeName = this.serializer.readString(this.input);
        }
        this.version = Conversion.getFlag(flags, 8) ? this.input.readLong() : -1L;
        this.parentID = Conversion.getFlag(flags, 2) ? new ObjectID(this.input.readLong()) : ObjectID.NULL_ID;
        this.arrayLength = Conversion.getFlag(flags, 1) ? this.input.readInt() : -1;
        if (this.hasMetaData()) {
            TCByteBufferInput metaDataInput = this.input.duplicate();
            metaDataInput.skip(this.metaDataOffset - (this.input.getTotalLength() - this.input.available()));
            this.metaDataReader = new MetaDataReaderImpl(metaDataInput, this.serializer);
        }
        return this;
    }

    @Override
    public int getActionCount() {
        return this.actionCount;
    }

    @Override
    public boolean isDelta() {
        return this.isDelta;
    }

    @Override
    public void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Reset is not supported by this class");
    }

    private static class NullMetaDataReader
    implements MetaDataReader {
        private NullMetaDataReader() {
        }

        @Override
        public Iterator<MetaDataDescriptorInternal> iterator() {
            return Collections.EMPTY_LIST.iterator();
        }
    }

    private static class MetaDataIterator
    implements Iterator<MetaDataDescriptorInternal> {
        private final TCByteBufferInput input;
        private final ObjectStringSerializer serializer;

        MetaDataIterator(TCByteBufferInput input, ObjectStringSerializer serializer) {
            this.input = input;
            this.serializer = serializer;
        }

        @Override
        public boolean hasNext() {
            return this.input.available() > 0;
        }

        @Override
        public MetaDataDescriptorInternal next() {
            try {
                int length = this.input.readInt();
                TCByteBufferInput.Mark start = this.input.mark();
                this.input.skip(length - 4);
                TCByteBufferInput.Mark end = this.input.mark();
                return MetaDataDescriptorImpl.deserializeInstance(new TCByteBufferInputStream(this.input.toArray(start, end)), this.serializer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MetaDataReaderImpl
    implements MetaDataReader {
        private final TCByteBufferInput input;
        private final ObjectStringSerializer serializer;

        MetaDataReaderImpl(TCByteBufferInput input, ObjectStringSerializer serializer) {
            this.input = input;
            this.serializer = serializer;
        }

        @Override
        public Iterator<MetaDataDescriptorInternal> iterator() {
            return new MetaDataIterator(this.input.duplicate(), this.serializer);
        }
    }
}

