/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.object.CompoundResponse;
import com.tc.object.ObjectID;
import com.tc.object.ServerMapRequestID;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ServerMapGetValueResponse {
    private static final long DEFAULT_VERSION = -1L;
    private final ServerMapRequestID requestID;
    private final Map<Object, Object> responseMap = new HashMap<Object, Object>();
    private final Map<ObjectID, CompoundResponse> replaceMap = new HashMap<ObjectID, CompoundResponse>();
    private int replaceCount;

    public ServerMapGetValueResponse(ServerMapRequestID requestID) {
        this.requestID = requestID;
    }

    public ServerMapRequestID getRequestID() {
        return this.requestID;
    }

    public Map<Object, Object> getValues() {
        return this.responseMap;
    }

    public void put(Object key, ObjectID value, boolean expectReplacement, long creationTime, long lastAccessedTime, long timeToIdle, long timeToLive, long version) {
        CompoundResponse setter = new CompoundResponse(value, creationTime, lastAccessedTime, timeToIdle, timeToLive, version);
        if (expectReplacement) {
            this.replaceMap.put(value, setter);
        }
        this.responseMap.put(key, setter);
    }

    public void put(Object key, ObjectID value) {
        this.put(key, value, false, 0L, 0L, 0L, 0L, -1L);
    }

    public Set<ObjectID> getObjectIDs() {
        return this.replaceMap.keySet();
    }

    public boolean replace(ObjectID oid, Object value) {
        CompoundResponse placed = this.replaceMap.remove(oid);
        if (placed != null) {
            placed.setData(value);
            ++this.replaceCount;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerMapGetValueResponse) {
            ServerMapGetValueResponse response = (ServerMapGetValueResponse)obj;
            return this.getRequestID().equals(response.getRequestID()) && this.getValues().equals(response.getValues());
        }
        return false;
    }

    public int hashCode() {
        return this.requestID.hashCode();
    }

    public String toString() {
        return "responses " + this.responseMap.size() + " replaces " + this.replaceMap.size() + " replace count " + this.replaceCount;
    }
}

