/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInputStream;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.transport.AckMessage;
import com.tc.net.protocol.transport.ConnectionID;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.SynAckMessage;
import com.tc.net.protocol.transport.SynMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.util.Assert;

class TransportMessageImpl
extends WireProtocolMessageImpl
implements SynMessage,
SynAckMessage,
AckMessage,
HealthCheckerProbeMessage {
    static final byte VERSION_1 = 1;
    static final byte VERSION_2 = 2;
    static final byte VERSION_3 = 3;
    static final byte VERSION_4 = 4;
    static final byte VERSION_5 = 5;
    static final byte VERSION = 5;
    static final byte SYN = 1;
    static final byte ACK = 2;
    static final byte SYN_ACK = 3;
    static final byte PING = 4;
    static final byte PING_REPLY = 5;
    static final byte TIME_CHECK = 6;
    private final byte version;
    private final byte type;
    private final ConnectionID connectionId;
    private final String errorContext;
    private final boolean hasErrorContext;
    private final int maxConnections;
    private final boolean isMaxConnectionsExceeded;
    private final short stackLayerFlags;
    private final short errorType;
    private final int callbackPort;
    private final long timestamp;

    TransportMessageImpl(TCConnection source, TCNetworkHeader header, TCByteBuffer[] payload) throws TCProtocolException {
        super(source, header, payload);
        try {
            TCByteBufferInputStream in = new TCByteBufferInputStream(payload);
            this.version = in.readByte();
            if (this.version != 5) {
                throw new TCProtocolException("Version Mismatch for Transport Message Handshake: " + this.version + " != 5");
            }
            this.type = in.readByte();
            this.connectionId = ConnectionID.readFrom(in);
            this.isMaxConnectionsExceeded = in.readBoolean();
            this.maxConnections = in.readInt();
            this.stackLayerFlags = in.readShort();
            this.callbackPort = in.readInt();
            this.hasErrorContext = in.readBoolean();
            if (this.hasErrorContext) {
                this.errorType = in.readShort();
                this.errorContext = in.readString();
            } else {
                this.errorType = 0;
                this.errorContext = null;
            }
            this.timestamp = this.type == 6 ? in.readLong() : -1L;
        }
        catch (TCProtocolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TCProtocolException("Exception reading data: ", e);
        }
    }

    @Override
    public void doRecycleOnWrite() {
        this.recycle();
    }

    @Override
    protected String describePayload() {
        return "type: " + this.typeToString() + ", connectionId: " + this.connectionId + ", timestamp: " + this.timestamp + ", errorContext " + this.errorContext + "\n";
    }

    private String typeToString() {
        switch (this.type) {
            case 1: {
                return "SYN";
            }
            case 2: {
                return "ACK";
            }
            case 3: {
                return "SYN_ACK";
            }
            case 4: {
                return "PING";
            }
            case 5: {
                return "PING_REPLY";
            }
            case 6: {
                return "TIME_CHECK";
            }
        }
        return "UNKNOWN";
    }

    @Override
    public ConnectionID getConnectionId() {
        return this.connectionId;
    }

    @Override
    public boolean hasErrorContext() {
        return this.hasErrorContext;
    }

    @Override
    public String getErrorContext() {
        Assert.eval(this.hasErrorContext());
        return this.errorContext;
    }

    @Override
    public short getErrorType() {
        Assert.eval(this.hasErrorContext());
        return this.errorType;
    }

    @Override
    public boolean isPing() {
        return this.type == 4;
    }

    @Override
    public boolean isPingReply() {
        return this.type == 5;
    }

    @Override
    public long getTime() {
        return this.timestamp;
    }

    @Override
    public boolean isSynAck() {
        return this.type == 3;
    }

    @Override
    public boolean isSyn() {
        return this.type == 1;
    }

    @Override
    public boolean isAck() {
        return this.type == 2;
    }

    @Override
    public boolean isTimeCheck() {
        return this.type == 6;
    }

    @Override
    public boolean isMaxConnectionsExceeded() {
        return this.isMaxConnectionsExceeded;
    }

    @Override
    public int getMaxConnections() {
        return this.maxConnections;
    }

    @Override
    public short getStackLayerFlags() {
        return this.stackLayerFlags;
    }

    @Override
    public int getCallbackPort() {
        return this.callbackPort;
    }
}

