/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.remote.protocol.terracotta;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.IOException;

public class TunneledDomainsChanged
extends DSOMessageBase {
    private static final byte DOMAINS = 1;
    private String[] tunneledDomains = null;

    public TunneledDomainsChanged(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public TunneledDomainsChanged(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public void initialize(String[] domains) {
        this.tunneledDomains = domains;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.tunneledDomains.length);
        for (String domain : this.tunneledDomains) {
            this.getOutputStream().writeString(domain);
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                int numberOfDomains = this.getIntValue();
                this.tunneledDomains = new String[numberOfDomains];
                for (int i = 0; i < numberOfDomains; ++i) {
                    this.tunneledDomains[i] = this.getInputStream().readString();
                }
                return true;
            }
        }
        return false;
    }

    public String[] getTunneledDomains() {
        return this.tunneledDomains;
    }
}

