/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.remote.protocol.terracotta;

import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import com.tc.util.UUID;
import java.io.IOException;

public class L1JmxReady
extends DSOMessageBase {
    private static final byte UUID = 1;
    private static final byte DOMAINS = 2;
    private UUID uuid = null;
    private String[] tunneledDomains = null;

    public L1JmxReady(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public L1JmxReady(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    public void initialize(UUID theUUID, String[] domains) {
        this.uuid = theUUID;
        this.tunneledDomains = domains;
    }

    public L1JmxReady createResponse() {
        L1JmxReady rv = (L1JmxReady)this.getChannel().createMessage(TCMessageType.CLIENT_JMX_READY_MESSAGE);
        rv.uuid = this.getUUID();
        return rv;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.uuid.toString());
        this.putNVPair((byte)2, this.tunneledDomains.length);
        for (String domain : this.tunneledDomains) {
            this.getOutputStream().writeString(domain);
        }
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 1: {
                this.uuid = new UUID(this.getStringValue());
                return true;
            }
            case 2: {
                int numberOfDomains = this.getIntValue();
                this.tunneledDomains = new String[numberOfDomains];
                for (int i = 0; i < numberOfDomains; ++i) {
                    this.tunneledDomains[i] = this.getInputStream().readString();
                }
                return true;
            }
        }
        return false;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public String[] getTunneledDomains() {
        return this.tunneledDomains;
    }
}

