/*
 * Decompiled with CFR 0.152.
 */
package com.tc.management.remote.protocol.terracotta;

import com.tc.bytes.TCByteBuffer;
import com.tc.exception.TCRuntimeException;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCByteBufferOutputStream;
import com.tc.io.TCSerializable;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageMonitor;
import com.tc.net.protocol.tcm.TCMessageHeader;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.DSOMessageBase;
import com.tc.object.session.SessionID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class JmxRemoteTunnelMessage
extends DSOMessageBase
implements TCSerializable {
    private static final byte TUNNEL_MESSAGE = 0;
    private static final byte FLAG = 1;
    private static final byte SYN_FLAG = 1;
    private static final byte DATA_FLAG = 2;
    private static final byte FIN_FLAG = 4;
    private Object tunneledMessage;
    private byte flag = (byte)2;

    public JmxRemoteTunnelMessage(SessionID sessionID, MessageMonitor monitor, TCByteBufferOutputStream out, MessageChannel channel, TCMessageType type) {
        super(sessionID, monitor, out, channel, type);
    }

    public JmxRemoteTunnelMessage(SessionID sessionID, MessageMonitor monitor, MessageChannel channel, TCMessageHeader header, TCByteBuffer[] data) {
        super(sessionID, monitor, channel, header, data);
    }

    @Override
    protected boolean hydrateValue(byte name) throws IOException {
        switch (name) {
            case 0: {
                this.setTunneledMessage(this.getObject(this));
                return true;
            }
            case 1: {
                this.setFlag(this.getByteValue());
                return true;
            }
        }
        return false;
    }

    @Override
    protected void dehydrateValues() {
        this.putNVPair((byte)1, this.flag);
        this.putNVPair((byte)0, this);
    }

    @Override
    public synchronized void serializeTo(TCByteBufferOutput serialOutput) {
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream(1024);
            ObjectOutputStream oos = new ObjectOutputStream(bao);
            oos.writeObject(this.tunneledMessage);
            oos.close();
            byte[] serializedObject = bao.toByteArray();
            serialOutput.writeByte(this.flag);
            serialOutput.writeInt(serializedObject.length);
            serialOutput.write(serializedObject);
        }
        catch (IOException ioe) {
            throw new TCRuntimeException(ioe);
        }
    }

    @Override
    public synchronized Object deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        try {
            this.flag = serialInput.readByte();
            int length = serialInput.readInt();
            byte[] serializedObject = new byte[length];
            serialInput.read(serializedObject);
            ByteArrayInputStream bis = new ByteArrayInputStream(serializedObject);
            ObjectInputStream ois = new ObjectInputStream(bis);
            return ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            throw new TCRuntimeException(cnfe);
        }
    }

    protected synchronized void setInitConnection() {
        this.setFlag((byte)1);
    }

    synchronized boolean getInitConnection() {
        return this.flag == 1;
    }

    synchronized void setCloseConnection() {
        this.setFlag((byte)4);
    }

    synchronized boolean getCloseConnection() {
        return this.flag == 4;
    }

    synchronized void setTunneledMessage(Object tunneledMessage) {
        this.tunneledMessage = tunneledMessage;
    }

    synchronized Object getTunneledMessage() {
        return this.tunneledMessage;
    }

    private synchronized void setFlag(byte flag) {
        this.flag = flag;
    }
}

