/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.EventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.l2.msg.RelayedCommitTransactionMessage;
import com.tc.l2.msg.ServerTxnAckMessage;
import com.tc.net.NodeID;
import com.tc.net.groups.MessageID;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.object.tx.ServerTransactionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ServerRelayedTxnAckMessage
extends ServerTxnAckMessage
implements EventContext {
    private static final int SERVER_RELAYED_TXN_ACK_MSG_TYPE = 0;
    private Set<ServerTransactionID> serverTxnIDs;
    private transient NodeID nodeID;

    public ServerRelayedTxnAckMessage() {
        super(-1);
    }

    public ServerRelayedTxnAckMessage(RelayedCommitTransactionMessage ackFor, Set<ServerTransactionID> serverTxnIDs) {
        this(ackFor.messageFrom(), ackFor.getMessageID(), serverTxnIDs);
    }

    public ServerRelayedTxnAckMessage(NodeID ackTo, MessageID ackFor, Set<ServerTransactionID> serverTxnIDs) {
        super(0, ackFor);
        this.nodeID = ackTo;
        this.serverTxnIDs = serverTxnIDs;
    }

    @Override
    public Set getAckedServerTxnIDs() {
        return this.serverTxnIDs;
    }

    @Override
    public NodeID getDestinationID() {
        Assert.assertNotNull(this.nodeID);
        return this.nodeID;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(0, this.getType());
        int size = in.readInt();
        this.serverTxnIDs = new HashSet<ServerTransactionID>(size);
        for (int i = 0; i < size; ++i) {
            NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
            nodeIDSerializer = (NodeIDSerializer)nodeIDSerializer.deserializeFrom(in);
            NodeID cid = nodeIDSerializer.getNodeID();
            long clientTxID = in.readLong();
            this.serverTxnIDs.add(new ServerTransactionID(cid, new TransactionID(clientTxID)));
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(0, this.getType());
        out.writeInt(this.serverTxnIDs.size());
        for (ServerTransactionID sTxID : this.serverTxnIDs) {
            NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(sTxID.getSourceID());
            nodeIDSerializer.serializeTo(out);
            out.writeLong(sTxID.getClientTransactionID().toLong());
        }
    }
}

