/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.lang.Recyclable;
import com.tc.net.NodeID;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.net.protocol.tcm.TCMessageImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.gtx.GlobalTransactionID;
import com.tc.object.tx.ServerTransactionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RelayedCommitTransactionMessage
extends AbstractGroupMessage
implements OrderedEventContext,
Recyclable {
    public static final int RELAYED_COMMIT_TXN_MSG_TYPE = 0;
    private TCByteBuffer[] batchData;
    private ObjectStringSerializer serializer;
    private Map sid2gid;
    private NodeID nodeID;
    private long sequenceID;
    private TCMessageImpl messageWrapper;
    private final boolean recyclable;
    private GlobalTransactionID lowWaterMark;

    public RelayedCommitTransactionMessage() {
        super(-1);
        this.recyclable = true;
    }

    public RelayedCommitTransactionMessage(NodeID nodeID, TCByteBuffer[] batchData, ObjectStringSerializer serializer, Map sid2gid, long seqID, GlobalTransactionID lowWaterMark) {
        super(0);
        this.nodeID = nodeID;
        this.batchData = batchData;
        this.serializer = serializer;
        this.sid2gid = sid2gid;
        this.sequenceID = seqID;
        this.lowWaterMark = lowWaterMark;
        this.recyclable = false;
    }

    public NodeID getClientID() {
        return this.nodeID;
    }

    public TCByteBuffer[] getBatchData() {
        return this.batchData;
    }

    public ObjectStringSerializer getSerializer() {
        return this.serializer;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(0, this.getType());
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer = (NodeIDSerializer)nodeIDSerializer.deserializeFrom(in);
        this.nodeID = nodeIDSerializer.getNodeID();
        this.serializer = new ObjectStringSerializerImpl();
        this.serializer.deserializeFrom(in);
        this.sid2gid = this.readServerTxnIDGlobalTxnIDMapping(in);
        this.sequenceID = in.readLong();
        this.lowWaterMark = new GlobalTransactionID(in.readLong());
        int size = in.readInt();
        this.batchData = in.duplicateAndLimit(size).toArray();
    }

    @Override
    public boolean isRecycleOnRead(TCMessageImpl messages) {
        this.messageWrapper = messages;
        return false;
    }

    private Map readServerTxnIDGlobalTxnIDMapping(TCByteBufferInput in) throws IOException {
        int size = in.readInt();
        HashMap<ServerTransactionID, GlobalTransactionID> mapping = new HashMap<ServerTransactionID, GlobalTransactionID>();
        NodeID cid = this.nodeID;
        for (int i = 0; i < size; ++i) {
            TransactionID txnid = new TransactionID(in.readLong());
            GlobalTransactionID gid = new GlobalTransactionID(in.readLong());
            mapping.put(new ServerTransactionID(cid, txnid), gid);
        }
        return mapping;
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(0, this.getType());
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.nodeID);
        nodeIDSerializer.serializeTo(out);
        this.serializer.serializeTo(out);
        this.writeServerTxnIDGlobalTxnIDMapping(out);
        out.writeLong(this.sequenceID);
        out.writeLong(this.lowWaterMark.toLong());
        this.writeByteBuffers(out, this.batchData);
    }

    private void writeServerTxnIDGlobalTxnIDMapping(TCByteBufferOutput out) {
        out.writeInt(this.sid2gid.size());
        NodeID cid = this.nodeID;
        for (Map.Entry e : this.sid2gid.entrySet()) {
            ServerTransactionID sid = (ServerTransactionID)e.getKey();
            Assert.assertEquals(cid, sid.getSourceID());
            out.writeLong(sid.getClientTransactionID().toLong());
            GlobalTransactionID gid = (GlobalTransactionID)e.getValue();
            out.writeLong(gid.toLong());
        }
    }

    public GlobalTransactionID getGlobalTransactionIDFor(ServerTransactionID serverTransactionID) {
        GlobalTransactionID gid = (GlobalTransactionID)this.sid2gid.get(serverTransactionID);
        if (gid == null) {
            throw new AssertionError((Object)("No Mapping found for : " + serverTransactionID));
        }
        return gid;
    }

    public GlobalTransactionID getLowGlobalTransactionIDWatermark() {
        return this.lowWaterMark;
    }

    @Override
    public long getSequenceID() {
        return this.sequenceID;
    }

    @Override
    public void recycle() {
        Assert.assertTrue(this.recyclable);
        this.messageWrapper.recycle();
    }
}

