/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.MessageID;
import com.tc.util.State;
import java.io.IOException;

public class PassiveSyncBeginMessage
extends AbstractGroupMessage {
    static final int REQUEST = 0;
    static final int RESPONSE = 1;
    static final int ERROR = 2;
    private State currentState;

    public PassiveSyncBeginMessage() {
        this(-1);
    }

    public PassiveSyncBeginMessage(int type) {
        super(type);
    }

    public PassiveSyncBeginMessage(int type, MessageID requestID) {
        super(type, requestID);
    }

    public boolean isRequest() {
        return this.getType() == 0;
    }

    public boolean isResponse() {
        return this.getType() == 1;
    }

    public boolean isError() {
        return this.getType() == 2;
    }

    public void setCurrentState(State state) {
        if (!this.isResponse()) {
            throw new IllegalStateException();
        }
        this.currentState = state;
    }

    public State getCurrentState() {
        if (!this.isResponse()) {
            throw new IllegalStateException();
        }
        return this.currentState;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        if (this.getType() == 1) {
            this.currentState = new State(in.readString());
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        if (this.getType() == 1) {
            out.writeString(this.currentState.getName());
        }
    }

    private String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return "REQUEST";
            }
            case 1: {
                return "RESPONSE";
            }
            case 2: {
                return "ERROR";
            }
        }
        return "UNKNOWN";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PassiveSyncBeginMessage message = (PassiveSyncBeginMessage)o;
        if (this.getType() != message.getType()) {
            return false;
        }
        return !(this.currentState != null ? !this.currentState.equals(message.currentState) : message.currentState != null);
    }

    public int hashCode() {
        int hash = this.getType();
        if (this.currentState != null) {
            hash = 31 * hash + this.currentState.hashCode();
        }
        return hash;
    }

    public String toString() {
        return "PassiveSyncBeginMessage{type=" + this.getTypeString() + ", currentState=" + this.currentState + "}";
    }

    public static PassiveSyncBeginMessage beginRequest() {
        return new PassiveSyncBeginMessage(0);
    }

    public static PassiveSyncBeginMessage beginResponse(State currentState) {
        PassiveSyncBeginMessage message = new PassiveSyncBeginMessage(1);
        message.setCurrentState(currentState);
        return message;
    }

    public static PassiveSyncBeginMessage beginError() {
        return new PassiveSyncBeginMessage(2);
    }
}

