/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.OrderedEventContext;
import com.tc.bytes.TCByteBuffer;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferInputStream;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.NodeIDSerializer;
import com.tc.object.ObjectID;
import com.tc.object.dna.impl.ObjectDNAImpl;
import com.tc.object.dna.impl.ObjectStringSerializer;
import com.tc.object.dna.impl.ObjectStringSerializerImpl;
import com.tc.object.tx.ServerTransactionID;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import com.tc.util.BasicObjectIDSet;
import com.tc.util.ObjectIDSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectSyncMessage
extends AbstractGroupMessage
implements OrderedEventContext {
    public static final int MANAGED_OBJECT_SYNC_TYPE = 0;
    private ObjectIDSet deletedOids;
    private ObjectIDSet oids;
    private int dnaCount;
    private TCByteBuffer[] dnas;
    private ObjectStringSerializer serializer;
    private Map rootsMap;
    private long sequenceID;
    private ServerTransactionID servertxnID;

    public ObjectSyncMessage() {
        super(-1);
    }

    public ObjectSyncMessage(ServerTransactionID stxnID, ObjectIDSet dnaOids, int count, TCByteBuffer[] serializedDNAs, ObjectStringSerializer objectSerializer, Map<String, ObjectID> roots, long sqID, ObjectIDSet deletedObjectIds) {
        super(0);
        this.servertxnID = stxnID;
        this.oids = dnaOids;
        this.dnaCount = count;
        this.dnas = serializedDNAs;
        this.serializer = objectSerializer;
        this.rootsMap = roots;
        this.sequenceID = sqID;
        this.deletedOids = deletedObjectIds;
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(0, this.getType());
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer();
        nodeIDSerializer = (NodeIDSerializer)nodeIDSerializer.deserializeFrom(in);
        this.servertxnID = new ServerTransactionID(nodeIDSerializer.getNodeID(), new TransactionID(in.readLong()));
        this.oids = new BasicObjectIDSet();
        this.oids.deserializeFrom(in);
        this.dnaCount = in.readInt();
        this.readRootsMap(in);
        this.serializer = new ObjectStringSerializerImpl();
        this.serializer.deserializeFrom(in);
        this.dnas = this.readByteBuffers(in);
        this.sequenceID = in.readLong();
        this.deletedOids = new BasicObjectIDSet();
        this.deletedOids.deserializeFrom(in);
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(0, this.getType());
        NodeIDSerializer nodeIDSerializer = new NodeIDSerializer(this.servertxnID.getSourceID());
        nodeIDSerializer.serializeTo(out);
        out.writeLong(this.servertxnID.getClientTransactionID().toLong());
        this.oids.serializeTo(out);
        out.writeInt(this.dnaCount);
        this.writeRootsMap(out);
        this.serializer.serializeTo(out);
        this.writeByteBuffers(out, this.dnas);
        this.recycle(this.dnas);
        this.dnas = null;
        out.writeLong(this.sequenceID);
        this.deletedOids.serializeTo(out);
    }

    private void writeRootsMap(TCByteBufferOutput out) {
        out.writeInt(this.rootsMap.size());
        for (Map.Entry e : this.rootsMap.entrySet()) {
            out.writeString((String)e.getKey());
            out.writeLong(((ObjectID)e.getValue()).toLong());
        }
    }

    private void readRootsMap(TCByteBufferInput in) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            this.rootsMap = Collections.EMPTY_MAP;
        } else {
            this.rootsMap = new HashMap(size);
            for (int i = 0; i < size; ++i) {
                this.rootsMap.put(in.readString(), new ObjectID(in.readLong()));
            }
        }
    }

    private void recycle(TCByteBuffer[] buffers) {
        for (TCByteBuffer buffer : buffers) {
            buffer.recycle();
        }
    }

    public int getDnaCount() {
        return this.dnaCount;
    }

    public ObjectIDSet getOids() {
        return this.oids;
    }

    public Map getRootsMap() {
        return this.rootsMap;
    }

    public List getDNAs() {
        Assert.assertNotNull(this.dnas);
        TCByteBufferInputStream toi = new TCByteBufferInputStream(this.dnas);
        ArrayList<ObjectDNAImpl> objectDNAs = new ArrayList<ObjectDNAImpl>(this.dnaCount);
        for (int i = 0; i < this.dnaCount; ++i) {
            ObjectDNAImpl dna = new ObjectDNAImpl(this.serializer, false);
            try {
                dna.deserializeFrom(toi);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Assert.assertFalse(dna.isDelta());
            objectDNAs.add(dna);
        }
        this.dnas = null;
        return objectDNAs;
    }

    public TCByteBuffer[] getUnprocessedDNAs() {
        TCByteBuffer[] tcbb = new TCByteBuffer[this.dnas.length];
        for (int i = 0; i < this.dnas.length; ++i) {
            tcbb[i] = this.dnas[i];
        }
        return tcbb;
    }

    @Override
    public long getSequenceID() {
        return this.sequenceID;
    }

    public ServerTransactionID getServerTransactionID() {
        return this.servertxnID;
    }

    public ObjectIDSet getDeletedOids() {
        return this.deletedOids;
    }
}

