/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.net.groups.MessageID;
import com.tc.util.State;
import java.io.IOException;

public class ObjectListSyncMessage
extends AbstractGroupMessage {
    public static final int REQUEST = 0;
    public static final int RESPONSE = 1;
    public static final int FAILED_RESPONSE = 2;
    private boolean syncAllowed;
    private State currentState;
    private long dataStorageSize;
    private long offheapSize;

    public ObjectListSyncMessage() {
        super(-1);
    }

    public ObjectListSyncMessage(int type) {
        super(type);
    }

    public ObjectListSyncMessage(MessageID messageID, int type, State currentState, boolean syncAllowed, long dataStorageSize, long offheapSize) {
        super(type, messageID);
        this.syncAllowed = syncAllowed;
        this.currentState = currentState;
        this.dataStorageSize = dataStorageSize;
        this.offheapSize = offheapSize;
    }

    public ObjectListSyncMessage(MessageID messageID, int type) {
        super(type, messageID);
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        switch (this.getType()) {
            case 0: 
            case 2: {
                break;
            }
            case 1: {
                this.currentState = new State(in.readString());
                this.syncAllowed = in.readBoolean();
                this.dataStorageSize = in.readLong();
                this.offheapSize = in.readLong();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown Message Type : " + this.getType()));
            }
        }
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        switch (this.getType()) {
            case 0: 
            case 2: {
                break;
            }
            case 1: {
                out.writeString(this.currentState.getName());
                out.writeBoolean(this.syncAllowed);
                out.writeLong(this.dataStorageSize);
                out.writeLong(this.offheapSize);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown Message Type : " + this.getType()));
            }
        }
    }

    public State getCurrentState() {
        return this.currentState;
    }

    public long getDataStorageSize() {
        return this.dataStorageSize;
    }

    public boolean isSyncAllowed() {
        return this.syncAllowed;
    }

    public long getOffheapSize() {
        return this.offheapSize;
    }

    public String toString() {
        return new StringBuffer(this.getClass().getSimpleName()).append("(").append("type=").append(this.getTypeString()).append(",syncAllowed=").append(this.syncAllowed).append(",currentState=").append(this.currentState).append(",dataStorageSize=").append(this.dataStorageSize).append(",offheapSize=").append(this.offheapSize).append(")").toString();
    }

    private String getTypeString() {
        switch (this.getType()) {
            case 0: {
                return "REQUEST";
            }
            case 2: {
                return "FAILED_RESPONSE";
            }
            case 1: {
                return "RESPONSE";
            }
        }
        throw new AssertionError((Object)("Unknown Type ! : " + this.getType()));
    }

    public static ObjectListSyncMessage createObjectListSyncRequestMessage() {
        return new ObjectListSyncMessage(0);
    }

    public static ObjectListSyncMessage createObjectListSyncResponseMessage(ObjectListSyncMessage initiatingMsg, State currentState, boolean syncAllowed, long dataStorageSize, long offheapSize) {
        return new ObjectListSyncMessage(initiatingMsg.getMessageID(), 1, currentState, syncAllowed, dataStorageSize, offheapSize);
    }

    public static ObjectListSyncMessage createObjectListSyncFailedResponseMessage(ObjectListSyncMessage initiatingMsg) {
        return new ObjectListSyncMessage(initiatingMsg.getMessageID(), 2);
    }
}

