/*
 * Decompiled with CFR 0.152.
 */
package com.tc.l2.msg;

import com.tc.async.api.EventContext;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.net.groups.AbstractGroupMessage;
import com.tc.objectserver.dgc.api.GarbageCollectionInfo;
import com.tc.util.Assert;
import com.tc.util.BasicObjectIDSet;
import com.tc.util.ObjectIDSet;
import java.io.IOException;
import java.util.SortedSet;

public class GCResultMessage
extends AbstractGroupMessage
implements EventContext {
    public static final int GC_RESULT = 0;
    private ObjectIDSet gcedOids;
    private GarbageCollectionInfo gcInfo;

    public GCResultMessage() {
        super(-1);
    }

    public GCResultMessage(GarbageCollectionInfo gcInfo, ObjectIDSet deleted) {
        super(0);
        this.gcInfo = gcInfo;
        this.gcedOids = deleted;
    }

    public int getGCIterationCount() {
        return (int)this.gcInfo.getGarbageCollectionID().toLong();
    }

    @Override
    protected void basicDeserializeFrom(TCByteBufferInput in) throws IOException {
        Assert.assertEquals(0, this.getType());
        this.gcInfo = new GarbageCollectionInfo();
        this.gcInfo.deserializeFrom(in);
        this.gcedOids = new BasicObjectIDSet();
        this.gcedOids.deserializeFrom(in);
    }

    @Override
    protected void basicSerializeTo(TCByteBufferOutput out) {
        Assert.assertEquals(0, this.getType());
        this.gcInfo.serializeTo(out);
        this.gcedOids.serializeTo(out);
    }

    public SortedSet getGCedObjectIDs() {
        return this.gcedOids;
    }

    public GarbageCollectionInfo getGCInfo() {
        return this.gcInfo;
    }

    public String toString() {
        return "DGCResultMessage@" + System.identityHashCode(this) + " : DGC Info = " + this.gcInfo + " Result size = " + (String)(this.gcedOids == null ? "null" : "" + this.gcedOids.size());
    }
}

